(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    121860,       3457]
NotebookOptionsPosition[    108932,       3145]
NotebookOutlinePosition[    109319,       3161]
CellTagsIndexPosition[    109276,       3158]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Math 203 - Multivariable Calculus", "Title",
 CellChangeTimes->{{3.7132352480035334`*^9, 3.7132352566671543`*^9}, {
  3.7132353840015993`*^9, 
  3.713235386162277*^9}},ExpressionUUID->"3eff84e4-7dc3-473c-9d5f-\
5004e7960755"],

Cell[CellGroupData[{

Cell[TextData[{
 "The Dot Product\n",
 StyleBox["September 8, 2017", "Subchapter"]
}], "Chapter",
 CellChangeTimes->{{3.7132354004820967`*^9, 3.713235406034102*^9}, {
  3.713236857004621*^9, 3.713236868548688*^9}, {3.7134660159867067`*^9, 
  3.7134660259792247`*^9}, {3.7136367302253275`*^9, 3.7136367303689313`*^9}, {
  3.7136390134313707`*^9, 3.713639019486205*^9}, {3.7138289066862593`*^9, 
  3.713828911468053*^9}},ExpressionUUID->"cd208c94-3888-4865-a79a-\
42dbba478bef"],

Cell["\<\
This link has a list of keyboard shortcuts for Mathematica. This can make \
entering integrals, derivatives, and other things easier! \
\>", "Text",
 CellChangeTimes->{{3.7134655860006123`*^9, 3.713465664555203*^9}, {
  3.713465698217385*^9, 3.713465718323245*^9}, {3.7134658334571447`*^9, 
  3.713465872458172*^9}},ExpressionUUID->"76986328-9708-4592-8069-\
c192c864c775"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hyperlink", "[", 
  RowBox[{
  "\"\<Keyboard Shortcuts\>\"", ",", 
   "\"\<http://reference.wolfram.com/language/tutorial/\
KeyboardShortcutListing.html\>\""}], "]"}]], "Code",
 CellOpen->False,
 CellChangeTimes->{{3.7134655860006123`*^9, 3.713465664555203*^9}, {
  3.713465698217385*^9, 
  3.7134657576928744`*^9}},ExpressionUUID->"ee24972e-5cdf-4b09-99c4-\
a324ddf3ac04"],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->"\<\"Keyboard Shortcuts\"\>", True->
    StyleBox["\<\"Keyboard Shortcuts\"\>", "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaseStyle->{"Hyperlink"},
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{
     URL["http://reference.wolfram.com/language/tutorial/\
KeyboardShortcutListing.html"], None},
   ButtonNote->
    "http://reference.wolfram.com/language/tutorial/KeyboardShortcutListing.\
html"],
  Annotation[#, 
   "http://reference.wolfram.com/language/tutorial/KeyboardShortcutListing.\
html", "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.713465760187833*^9, 3.7136407538491297`*^9, 
  3.7138327273600025`*^9, 
  3.714076419473363*^9},ExpressionUUID->"85584dbe-537f-4a39-a10a-\
8888852cd259"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 1", "Section",
 CellChangeTimes->{{3.7132354217860603`*^9, 3.713235422873678*^9}, {
  3.7132357083691387`*^9, 
  3.713235713385277*^9}},ExpressionUUID->"03899cad-2d7f-4aa5-9757-\
7093b5aa4e28"],

Cell["\<\
Which of the following expressions are meaningful? Which are meaningless? \
Explain.\
\>", "Text",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 
   3.713828982326439*^9}},ExpressionUUID->"a5183d42-ee6f-4ae5-8549-\
7f876366e5d8"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
     OverscriptBox["b", "\[RightVector]"]}], ")"}], "\[CenterDot]", 
   OverscriptBox["c", "\[RightVector]"]}], 
  TraditionalForm]],ExpressionUUID->"24575935-4de6-4b83-b2ed-913e4630d60e"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 3.7138290224907556`*^9}, {
   3.7138291065242825`*^9, 3.7138291079064217`*^9}, {3.713829187019124*^9, 
   3.7138292399624424`*^9}},ExpressionUUID->"1f3bc904-c3e6-42e4-bcf2-\
8723aead5e46"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
     OverscriptBox["b", "\[RightVector]"]}], ")"}], 
   OverscriptBox["c", "\[RightVector]"]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"bfc30521-fb29-4499-9613-c0dd3398b92c"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 3.7138290224907556`*^9}, {
   3.7138291065242825`*^9, 3.7138291079064217`*^9}, {3.713829187019124*^9, 
   3.7138292715710607`*^9}},ExpressionUUID->"42eca4df-4da1-4ef3-8d1f-\
113dcd6efaff"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"||", 
   OverscriptBox["a", "\[RightVector]"], "||", 
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["b", "\[RightVector]"], "\[CenterDot]", 
     OverscriptBox["c", "\[RightVector]"]}], ")"}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"82fccb7a-cef5-42ed-b579-becc378f6c2d"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 3.7138290224907556`*^9}, {
   3.7138291065242825`*^9, 3.7138291079064217`*^9}, {3.713829187019124*^9, 
   3.7138293052591085`*^9}},ExpressionUUID->"29c00166-3d0e-4e1d-856a-\
0a740b68e487"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["b", "\[RightVector]"], "+", 
     OverscriptBox["c", "\[RightVector]"]}], ")"}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"4a6a1212-eea7-442c-8a2d-e87c5ae0a35c"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 3.7138290224907556`*^9}, {
   3.7138291065242825`*^9, 3.7138291079064217`*^9}, {3.713829187019124*^9, 
   3.71382934190825*^9}},ExpressionUUID->"2160c534-357f-489e-bf48-\
fdb5c6e5c8c9"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
    OverscriptBox["b", "\[RightVector]"]}], "+", 
   OverscriptBox["c", "\[RightVector]"]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"4fa7eac7-f7d1-43d7-bc57-bd05340e490c"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 3.7138290224907556`*^9}, {
   3.7138291065242825`*^9, 3.7138291079064217`*^9}, {3.713829187019124*^9, 
   3.713829362355802*^9}},ExpressionUUID->"2f78b353-3cef-4b0e-9f88-\
a4ee96dc91f4"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"||", 
   OverscriptBox["a", "\[RightVector]"], "||", 
   RowBox[{"\[CenterDot]", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["b", "\[RightVector]"], "+", 
      OverscriptBox["c", "\[RightVector]"]}], ")"}]}]}], 
  TraditionalForm]],ExpressionUUID->"c4fa37ee-ddca-4ae3-a38a-e2c872c1cef6"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 3.7138290224907556`*^9}, {
   3.7138291065242825`*^9, 3.7138291079064217`*^9}, {3.713829187019124*^9, 
   3.713829393573675*^9}},ExpressionUUID->"acb33c85-505a-4cfd-aa17-\
210c071f5cae"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714075733476268*^9, 
  3.714075736106078*^9}},ExpressionUUID->"18c22fb9-2e70-4711-88dd-\
a08aafe973de"],

Cell[CellGroupData[{

Cell[TextData[{
 "Meaningless since you cannot dot a scalar ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
     OverscriptBox["b", "\[RightVector]"]}], ")"}], TraditionalForm]],
  ExpressionUUID->"1226efdf-22c5-489b-a2e6-a3d4d1afc97a"],
 " with a vector."
}], "ItemNumbered",
 CellChangeTimes->{{3.714075733476268*^9, 
  3.7140757862313957`*^9}},ExpressionUUID->"e107b0f5-8a8b-4c46-ba89-\
e59b68ca7701"],

Cell["Meaningful since you can multiply a vector by a scalar.", "ItemNumbered",
 CellChangeTimes->{{3.714075733476268*^9, 
  3.714075796215448*^9}},ExpressionUUID->"9bc2e609-40c5-4bf7-826e-\
aae12f4853b5"],

Cell["Meaningful since this is just a product of two scalars.", "ItemNumbered",
 CellChangeTimes->{{3.714075733476268*^9, 
  3.7140758137176037`*^9}},ExpressionUUID->"2a06fff7-709f-4e9e-9da5-\
b4dc0e59ac1a"],

Cell["\<\
Meaningful since you can take the dot product of two vectors.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.714075733476268*^9, 
  3.7140758289666133`*^9}},ExpressionUUID->"8b4cb748-6861-46f0-8e55-\
466bfa2920df"],

Cell[TextData[{
 "Meaningless since you cannot add a scalar ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
    OverscriptBox["b", "\[RightVector]"]}], TraditionalForm]],ExpressionUUID->
  "79501425-9439-4ea9-a6af-5ed6028e3006"],
 " to a vector."
}], "ItemNumbered",
 CellChangeTimes->{{3.714075733476268*^9, 
  3.7140758572722516`*^9}},ExpressionUUID->"0e59d9a8-4e95-40ac-9176-\
8e01b07abd3d"],

Cell[TextData[{
 "Meaningless since you cannot dot a scalar ",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", " ", 
    OverscriptBox["a", "\[RightVector]"], " ", "||"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c4c38af0-53a9-4a25-9d05-2fa191b30df8"],
 " with a vector."
}], "ItemNumbered",
 CellChangeTimes->{{3.714075733476268*^9, 
  3.7140758998973193`*^9}},ExpressionUUID->"3e36e8e3-5b66-483d-8cc9-\
3f75d7d07ce3"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 2", "Section",
 CellChangeTimes->{{3.7132357351372943`*^9, 
  3.7132357361843896`*^9}},ExpressionUUID->"38cc62da-8763-4d8f-ac77-\
780f62bc6421"],

Cell[TextData[{
 "Compute the dot product ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "\[CenterDot]", 
    OverscriptBox["v", "\[RightVector]"]}], TraditionalForm]],ExpressionUUID->
  "9e49f622-e5f6-4fba-b913-e493b45847c2"],
 " for the following pairs of vectors:"
}], "Text",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 
   3.713829601921364*^9}},ExpressionUUID->"1d9ab7fd-e147-4aff-97f9-\
463aa05e410e"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "3"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],ExpressionUUID->"892720d7-f1f1-46c5-81c8-508849386ef3"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["v", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"0.7", ",", "1.2"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],ExpressionUUID->"1fe7b8a8-3ba7-4c00-bab6-5fc70345b3dc"]
}], "ItemNumbered",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829598022792*^9}, {
   3.7138296714885693`*^9, 3.7138297365061035`*^9}, {3.7140681968056355`*^9, 
   3.7140682050753803`*^9}},ExpressionUUID->"d80ae43f-9222-4b0c-aff2-\
169196a71a2f"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"6", ",", 
      RowBox[{"-", "2"}], ",", "3"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],ExpressionUUID->"544b9dba-10e9-45db-bf79-23d041d4c909"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["v", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"2", ",", "5", ",", 
      RowBox[{"-", "1"}]}], "\[RightAngleBracket]"}]}], TraditionalForm]],
  ExpressionUUID->"c98a3d59-97d2-4473-a73f-fa576d0a573f"]
}], "ItemNumbered",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829598022792*^9}, {
   3.7138296714885693`*^9, 3.7138297142568293`*^9}, {3.71382974610711*^9, 
   3.71382975535451*^9}, {3.714068208755582*^9, 
   3.7140682158658695`*^9}},ExpressionUUID->"3ff217c3-b7c1-438f-99a6-\
b67611ba8092"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{"3", 
      OverscriptBox["i", "^"]}], "+", 
     RowBox[{"2", 
      OverscriptBox["j", "^"]}], "-", 
     OverscriptBox["k", "^"]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "9ecb4b7a-0ba0-4878-9537-ce5ef8939b89"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["v", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{"4", 
      OverscriptBox["i", "^"]}], "+", 
     RowBox[{"5", 
      OverscriptBox["k", "^"]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "17d59b44-8cc9-40b0-aa64-87759e8bd0de"]
}], "ItemNumbered",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829598022792*^9}, {
   3.7138296714885693`*^9, 3.7138297155850883`*^9}, {3.713829767043283*^9, 
   3.71382984619882*^9}, {3.7138725072642145`*^9, 
   3.7138725604186316`*^9}},ExpressionUUID->"394bea68-150c-46e1-9e73-\
f7d608a002de"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"||", 
     OverscriptBox["u", "\[RightVector]"], "||"}], "=", "6"}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "34dcf170-f481-4544-a773-796cedaf8884"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"||", 
     OverscriptBox["v", "\[RightVector]"], "||"}], "=", "5"}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "537c765d-1dad-40e3-9cfe-b1ecd6d8265b"],
 ", and the angle between ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["u", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "7af77e63-c15e-41b9-a79c-cdc02d7023ef"],
 " and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["v", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "933e976a-2452-4945-b4eb-1d22c6d7b02e"],
 " is ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"2", "\[Pi]"}], "3"],
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "6f116a45-a471-4dba-92c3-a587f92a3eda"]
}], "ItemNumbered",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829598022792*^9}, {
   3.7138296714885693`*^9, 3.7138297159526176`*^9}, {3.7138298542530317`*^9, 
   3.713829921027093*^9}},ExpressionUUID->"9777d424-a789-4afa-9e35-\
3308585daccd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714075915472231*^9, 
  3.7140759177585506`*^9}},ExpressionUUID->"5cbdedcc-48ae-4a97-9409-\
224e2b706a40"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "\[CenterDot]", 
    OverscriptBox["v", "\[RightVector]"]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "2"}], ")"}], 
      RowBox[{"(", "0.7", ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", "3", ")"}], 
      RowBox[{"(", "1.2", ")"}]}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.4"}], "+", "3.6"}], "=", "2.2"}]}]}], 
  TraditionalForm]],ExpressionUUID->"9683fc6a-e679-4fdb-aea6-07f42114a563"]], \
"ItemNumbered",
 CellChangeTimes->{{3.714075915472231*^9, 3.7140759163679323`*^9}, {
  3.7140759905457954`*^9, 
  3.714076017908497*^9}},ExpressionUUID->"88f99702-eb56-42e7-9a87-\
2b8ac9cd6a8f"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "\[CenterDot]", 
    OverscriptBox["v", "\[RightVector]"]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", "6", ")"}], 
      RowBox[{"(", "2", ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "2"}], ")"}], 
      RowBox[{"(", "5", ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", "3", ")"}], 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}]}], "=", 
    RowBox[{
     RowBox[{"12", "-", "10", "-", "3"}], "=", 
     RowBox[{"-", "1"}]}]}]}], 
  TraditionalForm]],ExpressionUUID->"e88c9c2b-8bff-4836-b11d-e345abe8f173"]], \
"ItemNumbered",
 CellChangeTimes->{{3.714075915472231*^9, 3.7140759163679323`*^9}, {
  3.7140759905457954`*^9, 
  3.714076042003891*^9}},ExpressionUUID->"bd33589e-3749-4705-99af-\
fa52041048e2"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "\[CenterDot]", 
    OverscriptBox["v", "\[RightVector]"]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", "3", ")"}], 
      RowBox[{"(", "4", ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", "2", ")"}], 
      RowBox[{"(", "0", ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"(", "5", ")"}]}]}], "=", 
    RowBox[{
     RowBox[{"12", "+", "0", "-", "5"}], "=", "7"}]}]}], 
  TraditionalForm]],ExpressionUUID->"0d0da3e2-f846-4396-b395-5d972ab37261"]], \
"ItemNumbered",
 CellChangeTimes->{{3.714075915472231*^9, 3.7140759163679323`*^9}, {
  3.7140759905457954`*^9, 
  3.714076068292471*^9}},ExpressionUUID->"3b8cd10b-5088-437b-b83e-\
46de3b864ce1"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "\[CenterDot]", 
    OverscriptBox["v", "\[RightVector]"]}], "=", 
   RowBox[{
    RowBox[{"||", 
     OverscriptBox["u", "\[RightVector]"], "||", " ", "||", 
     OverscriptBox["v", "\[RightVector]"], "||", " ", 
     RowBox[{"cos", " ", "\[Theta]"}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", "6", ")"}], 
      RowBox[{"(", "5", ")"}], "cos", 
      FractionBox[
       RowBox[{"2", "\[Pi]"}], "3"]}], "=", 
     RowBox[{
      RowBox[{"30", 
       RowBox[{"(", 
        FractionBox["1", "2"], ")"}]}], "=", "15"}]}]}]}], 
  TraditionalForm]],ExpressionUUID->"31771246-f901-409c-9e79-df95f51614a7"]], \
"ItemNumbered",
 CellChangeTimes->{{3.714075915472231*^9, 3.7140759163679323`*^9}, {
  3.7140759905457954`*^9, 
  3.7140761288857703`*^9}},ExpressionUUID->"51918772-dc1c-47b2-a6b9-\
244f679557fa"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 3", "Section",
 CellChangeTimes->{{3.7132359950315733`*^9, 
  3.713235996879508*^9}},ExpressionUUID->"b558e9de-89e6-468c-a384-\
951f2a0bdef8"],

Cell["\<\
Find the angle between the following pairs of vectors (i) exactly and (ii) \
approximated to the nearest degree. (You can use Mathematica to give a \
numerical approximation. See the example below. Note that the output below is \
in radians, not degrees.)\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
   3.713236248157117*^9, 3.713236274294656*^9}, 3.713236396338131*^9, {
   3.7132379028992043`*^9, 3.71323792599669*^9}, {3.7134675473040686`*^9, 
   3.7134675859134197`*^9}, {3.7136428763284693`*^9, 
   3.7136428790323772`*^9}, {3.713643046249902*^9, 3.71364306299399*^9}, {
   3.7136437575308104`*^9, 3.7136438636912003`*^9}, {3.7136439018477845`*^9, 
   3.7136440080690794`*^9}, {3.713644071284747*^9, 3.7136441183571525`*^9}, 
   3.7136441975609365`*^9, {3.7136447128742466`*^9, 3.7136447522104406`*^9}, {
   3.713644914915126*^9, 3.713644921883129*^9}, {3.713645031507679*^9, 
   3.7136451268371463`*^9}, {3.7138326110842867`*^9, 
   3.7138326912646074`*^9}, {3.7138723819566164`*^9, 
   3.7138723935333405`*^9}},ExpressionUUID->"ccc8c791-120b-45b3-90a9-\
0cbbece290b2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"ArcCos", "[", 
   RowBox[{
    RowBox[{"-", "8"}], "/", "13"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7138326962256994`*^9, 3.7138327471055984`*^9}, {
  3.7138723724776487`*^9, 
  3.7138724015817175`*^9}},ExpressionUUID->"e57947a8-b086-40eb-8d04-\
0beb64377c6e"],

Cell[BoxData["2.2336701504450325`"], "Output",
 CellChangeTimes->{{3.713832727489073*^9, 3.7138327491388397`*^9}, 
   3.713872402574129*^9},ExpressionUUID->"2cc7a174-6733-47a2-8ae7-\
14397d8bc836"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"4", ",", "3"}], "\[RightAngleBracket]"}]}], ",", " ", 
   RowBox[{
    OverscriptBox["b", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"2", ",", 
      RowBox[{"-", "1"}]}], "\[RightAngleBracket]"}]}]}], 
  TraditionalForm]],ExpressionUUID->"5be1538a-476b-4dff-b45b-b90e6c86c4a5"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7138329753016677`*^9, 3.713833006967522*^9}, {
  3.714068219516178*^9, 
  3.7140682260978403`*^9}},ExpressionUUID->"8b092377-9fe3-4555-8639-\
ec904edc3675"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"3", ",", 
      RowBox[{"-", "1"}], ",", "5"}], "\[RightAngleBracket]"}]}], ",", " ", 
   RowBox[{
    OverscriptBox["b", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "4", ",", "3"}], "\[RightAngleBracket]"}]}]}], 
  TraditionalForm]],ExpressionUUID->"9a962aa6-1f2c-4c7f-81b6-c7086f44cf26"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7138329753016677`*^9, 3.71383303486284*^9}, {
  3.7140682285453525`*^9, 
  3.7140682371931143`*^9}},ExpressionUUID->"97365afd-c2b7-47aa-a79c-\
3d0dbcdabf90"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714076142165354*^9, 
  3.714076145034265*^9}},ExpressionUUID->"66399f8f-4215-4956-b457-\
ef1db88410bf"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
     OverscriptBox["b", "\[RightVector]"]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", "4", ")"}], 
       RowBox[{"(", "2", ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", "3", ")"}], 
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}]}]}], "=", 
     RowBox[{
      RowBox[{"8", "-", "3"}], "=", "5"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "8800476f-8b4e-4eab-b4f0-9ffb6482aafb"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"||", 
     OverscriptBox["a", "\[RightVector]"], "||"}], "=", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox["4", "2"], "+", 
       SuperscriptBox["3", "2"]}]], "=", 
     RowBox[{
      SqrtBox[
       RowBox[{"16", "+", "9"}]], "=", "5"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "5fb43629-2baf-41fe-b6ba-a0ec8f9cc6b7"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"||", 
     OverscriptBox["b", "\[RightVector]"], "||"}], "=", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox["2", "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "2"]}]], "=", 
     RowBox[{
      SqrtBox[
       RowBox[{"4", "+", "1"}]], "=", 
      SqrtBox["5"]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "a8869154-1a6e-479a-87c4-875cb8b741dd"],
 " so the angle is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", 
    RowBox[{
     RowBox[{"arccos", 
      FractionBox["5", 
       RowBox[{"5", 
        SqrtBox["5"]}]]}], "=", 
     RowBox[{
      RowBox[{"arccos", " ", 
       FractionBox["1", 
        SqrtBox["5"]]}], "\[TildeTilde]"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "57e82922-be8e-4320-ad8e-3c75c7871562"],
 "63\[Degree]"
}], "ItemNumbered",
 CellChangeTimes->{{3.714076142165354*^9, 3.7140763847668505`*^9}, {
  3.714076450236888*^9, 
  3.714076461142991*^9}},ExpressionUUID->"b2dbcc23-2e8b-489b-ad81-\
354724c98a1e"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
     OverscriptBox["b", "\[RightVector]"]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", "3", ")"}], 
       RowBox[{"(", 
        RowBox[{"-", "2"}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"(", "4", ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", "5", ")"}], 
       RowBox[{"(", "3", ")"}]}]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], "-", "4", "+", "15"}], "=", "5"}]}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e730e56b-0915-409e-a51c-582f2e392b75"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"||", 
     OverscriptBox["a", "\[RightVector]"], "||"}], "=", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox["3", "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "2"], "+", 
       SuperscriptBox["5", "2"]}]], "=", 
     RowBox[{
      SqrtBox[
       RowBox[{"9", "+", "1", "+", "25"}]], "=", 
      SqrtBox["35"]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "70914b01-d7a6-47b9-8b2d-04d1556bd007"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"||", 
     OverscriptBox["b", "\[RightVector]"], "||"}], "=", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "2"}], ")"}], "2"], "+", 
       SuperscriptBox["4", "2"], "+", 
       SuperscriptBox["3", "2"]}]], "=", 
     RowBox[{
      SqrtBox[
       RowBox[{"4", "+", "16", "+", "9"}]], "=", 
      SqrtBox["29"]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c0ba3907-322f-4240-ad68-ab8c199fab1e"],
 " so the angle is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", 
    RowBox[{
     RowBox[{"arccos", 
      FractionBox["5", 
       RowBox[{
        SqrtBox["35"], 
        SqrtBox["29"]}]]}], "\[TildeTilde]"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e7ea075f-478f-4cdf-b2bc-6c22cb7a7385"],
 "81\[Degree]"
}], "ItemNumbered",
 CellChangeTimes->{{3.714076142165354*^9, 3.7140763847668505`*^9}, {
  3.714076450236888*^9, 3.7140765932248554`*^9}, {3.7140766239303894`*^9, 
  3.7140766241121397`*^9}},ExpressionUUID->"57d84f58-1f73-4928-8f3b-\
b7824347d3b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"ArcCos", "[", 
    RowBox[{"1", "/", 
     SqrtBox["5"]}], "]"}], "]"}], "*", 
  RowBox[{"(", 
   RowBox[{"180", "/", "\[Pi]"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.7140763980921273`*^9, 
  3.7140764374124746`*^9}},ExpressionUUID->"c54e45f2-f3d2-4b9e-aa07-\
c91a63cb3fdc"],

Cell[BoxData["63.43494882292201`"], "Output",
 CellChangeTimes->{{3.714076419611863*^9, 
  3.714076439788269*^9}},ExpressionUUID->"88cf8df5-b8bd-486e-9d5d-\
2e40d7ba7fc9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"ArcCos", "[", 
    FormBox[
     FractionBox["5", 
      RowBox[{
       SqrtBox["35"], 
       SqrtBox["29"]}]],
     TraditionalForm], "]"}], "]"}], "*", 
  RowBox[{"(", 
   RowBox[{"180", "/", "\[Pi]"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.7140766000696363`*^9, 
  3.714076615152544*^9}},ExpressionUUID->"544c0377-7287-4350-a258-\
bfc4ef4e6226"],

Cell[BoxData["80.97060282169403`"], "Output",
 CellChangeTimes->{
  3.7140766170382824`*^9},ExpressionUUID->"4dc3b344-cd28-44a9-a239-\
86e1d3dd5ceb"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 4", "Section",
 CellChangeTimes->{{3.713235999118843*^9, 
  3.7132360046164513`*^9}},ExpressionUUID->"d9f59dcc-177e-49cd-b037-\
24d5bddbc1a0"],

Cell["\<\
Determine whether the given vectors are orthogonal, parallel, or neither.\
\>", "Text",
 CellChangeTimes->{{3.7132363135506687`*^9, 3.713236316382722*^9}, 
   3.7132363828816257`*^9, {3.71323647404787*^9, 3.7132365234540377`*^9}, {
   3.713461784299481*^9, 3.71346178429998*^9}, {3.7134676414066696`*^9, 
   3.7134676617863455`*^9}, {3.7134677873763742`*^9, 
   3.7134677873763742`*^9}, {3.7134679124490924`*^9, 
   3.7134679124490924`*^9}, {3.713646471249406*^9, 3.713646631537095*^9}, {
   3.713651581074431*^9, 3.7136515819870415`*^9}, {3.713833128184634*^9, 
   3.713833157380231*^9}},ExpressionUUID->"896178d9-5051-44e2-b0a9-\
899683fefc89"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"-", "5"}], ",", "3", ",", "7"}], "\[RightAngleBracket]"}]}], 
   ",", " ", 
   RowBox[{
    OverscriptBox["b", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"6", ",", 
      RowBox[{"-", "8"}], ",", "2"}], "\[RightAngleBracket]"}]}]}], 
  TraditionalForm]],ExpressionUUID->"ea376bf9-17dd-4867-9071-43256db9da86"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132363135506687`*^9, 3.713236316382722*^9}, 
   3.7132363828816257`*^9, {3.71323647404787*^9, 3.7132365234540377`*^9}, {
   3.713461784299481*^9, 3.71346178429998*^9}, {3.7134676414066696`*^9, 
   3.7134676617863455`*^9}, {3.7134677873763742`*^9, 
   3.7134677873763742`*^9}, {3.7134679124490924`*^9, 
   3.7134679124490924`*^9}, {3.713646471249406*^9, 3.713646631537095*^9}, {
   3.713651581074431*^9, 3.7136515819870415`*^9}, {3.713833128184634*^9, 
   3.7138331545280476`*^9}, {3.7138332015602617`*^9, 
   3.7138332646510715`*^9}, {3.7140682397063026`*^9, 
   3.7140682470896597`*^9}},ExpressionUUID->"d2976e6c-e6c2-42e2-b5bc-\
505c941634fc"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"4", ",", "6"}], "\[RightAngleBracket]"}]}], ",", " ", 
   RowBox[{
    OverscriptBox["b", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"-", "3"}], ",", "2"}], "\[RightAngleBracket]"}]}]}], 
  TraditionalForm]],ExpressionUUID->"ca68b93e-83bc-4c0f-986f-8ccda697001f"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132363135506687`*^9, 3.713236316382722*^9}, 
   3.7132363828816257`*^9, {3.71323647404787*^9, 3.7132365234540377`*^9}, {
   3.713461784299481*^9, 3.71346178429998*^9}, {3.7134676414066696`*^9, 
   3.7134676617863455`*^9}, {3.7134677873763742`*^9, 
   3.7134677873763742`*^9}, {3.7134679124490924`*^9, 
   3.7134679124490924`*^9}, {3.713646471249406*^9, 3.713646631537095*^9}, {
   3.713651581074431*^9, 3.7136515819870415`*^9}, {3.713833128184634*^9, 
   3.7138331545280476`*^9}, {3.7138332015602617`*^9, 3.71383323454646*^9}, {
   3.7138332720346375`*^9, 3.7138332811003456`*^9}, {3.7140682488646703`*^9, 
   3.7140682560238705`*^9}},ExpressionUUID->"9cd443d3-9490-4a91-a011-\
8721dd4e9e2e"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{"-", 
      OverscriptBox["i", "^"]}], "+", 
     RowBox[{"2", 
      OverscriptBox["j", "^"]}], "+", 
     RowBox[{"5", 
      OverscriptBox["k", "^"]}]}]}], ",", " ", 
   RowBox[{
    OverscriptBox["b", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{"3", 
      OverscriptBox["i", "^"]}], "+", 
     RowBox[{"4", 
      OverscriptBox["j", "^"]}], "-", 
     OverscriptBox["k", "^"]}]}]}], 
  TraditionalForm]],ExpressionUUID->"3b4268eb-88b9-4a3a-9619-c606637d8214"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132363135506687`*^9, 3.713236316382722*^9}, 
   3.7132363828816257`*^9, {3.71323647404787*^9, 3.7132365234540377`*^9}, {
   3.713461784299481*^9, 3.71346178429998*^9}, {3.7134676414066696`*^9, 
   3.7134676617863455`*^9}, {3.7134677873763742`*^9, 
   3.7134677873763742`*^9}, {3.7134679124490924`*^9, 
   3.7134679124490924`*^9}, {3.713646471249406*^9, 3.713646631537095*^9}, {
   3.713651581074431*^9, 3.7136515819870415`*^9}, {3.713833128184634*^9, 
   3.7138331545280476`*^9}, {3.7138332015602617`*^9, 
   3.7138332355781527`*^9}, {3.7138333883975973`*^9, 
   3.7138334597356634`*^9}, {3.713872571244398*^9, 
   3.713872615001973*^9}},ExpressionUUID->"c4f9c06a-30f0-4ce9-adf3-\
4a71b29d23f5"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{"2", 
      OverscriptBox["i", "^"]}], "+", 
     RowBox[{"6", 
      OverscriptBox["j", "^"]}], "-", 
     RowBox[{"4", 
      OverscriptBox["k", "^"]}]}]}], ",", " ", 
   RowBox[{
    OverscriptBox["b", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], 
      OverscriptBox["i", "^"]}], "-", 
     RowBox[{"9", 
      OverscriptBox["j", "^"]}], "+", 
     RowBox[{"6", 
      OverscriptBox["k", "^"]}]}]}]}], 
  TraditionalForm]],ExpressionUUID->"d8ffc70d-948d-4200-980e-2cd70d8887a8"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132363135506687`*^9, 3.713236316382722*^9}, 
   3.7132363828816257`*^9, {3.71323647404787*^9, 3.7132365234540377`*^9}, {
   3.713461784299481*^9, 3.71346178429998*^9}, {3.7134676414066696`*^9, 
   3.7134676617863455`*^9}, {3.7134677873763742`*^9, 
   3.7134677873763742`*^9}, {3.7134679124490924`*^9, 
   3.7134679124490924`*^9}, {3.713646471249406*^9, 3.713646631537095*^9}, {
   3.713651581074431*^9, 3.7136515819870415`*^9}, {3.713833128184634*^9, 
   3.7138331545280476`*^9}, {3.7138332015602617`*^9, 
   3.7138332357305193`*^9}, {3.713833470213354*^9, 3.7138335349299917`*^9}, {
   3.713872572741889*^9, 
   3.7138726222427616`*^9}},ExpressionUUID->"9fa18956-7966-444e-9f04-\
270fd07f9faa"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7140772869410706`*^9, 
  3.714077289544092*^9}},ExpressionUUID->"0bb6b29c-5460-48e8-991e-\
c1bf04fed493"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
     OverscriptBox["b", "\[RightVector]"]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "5"}], ")"}], 
       RowBox[{"(", "6", ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", "3", ")"}], 
       RowBox[{"(", 
        RowBox[{"-", "8"}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", "7", ")"}], 
       RowBox[{"(", "2", ")"}]}]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "30"}], "-", "24", "+", "14"}], "=", 
      RowBox[{"-", "40"}]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c604c91d-d86e-4b2e-bba0-59d0d435fef7"],
 ", so the vectors are not orthogonal. The vectors are also not parallel \
since there is no scalar we can multiply by that would change one into the \
other. To see this, let\[CloseCurlyQuote]s try to turn ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["a", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "a6e369dc-3a11-4a7f-8861-3530f49e4df6"],
 " into ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["b", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "a9ce6410-6882-4769-be17-53cafd67189d"],
 ". Multiplying by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    FractionBox["6", "5"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4611d85a-128f-4e7f-8c50-715d7ebf131b"],
 " makes the first component match up: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["6", "5"]}], 
     RowBox[{"(", 
      RowBox[{"-", "5"}], ")"}]}], "=", "6"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d27c1ac6-e9e0-421a-8a89-3693190c8d05"],
 "; so it must be what we multiply by to get all the other components to \
match; however, the multiplying the second component gives: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["6", "5"]}], 
     RowBox[{"(", "3", ")"}]}], "=", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["18", "5"]}], "\[NotEqual]", 
     RowBox[{"-", "8"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "14efeeb4-a5a6-4558-8409-7021a2deba2a"],
 ", so the vectors are not parallel."
}], "ItemNumbered",
 CellChangeTimes->{{3.7140772869410706`*^9, 3.714077287677371*^9}, {
  3.714077355319442*^9, 
  3.7140775903822966`*^9}},ExpressionUUID->"0a205519-ae6f-417c-b0ac-\
c9464ffb438a"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", Cell[TextData[Cell[
    BoxData[
     FormBox[
      RowBox[{
       OverscriptBox["b", "\[RightVector]"], "=", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", "4", ")"}], 
          RowBox[{"(", 
           RowBox[{"-", "3"}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", "6", ")"}], 
          RowBox[{"(", "2", ")"}]}]}], "=", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "12"}], "+", "12"}], "=", "0"}]}]}], TraditionalForm]],
     FormatType->"TraditionalForm",ExpressionUUID->
     "2dcdc2ed-dd49-445e-a7ea-28fa7ce559fa"]],ExpressionUUID->
     "b8ead2aa-22e5-4790-8bd8-efac19380cc0"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c3cbb0ba-be76-4a4a-abe6-4f72cfa3c3e7"],
 ", so the vectors are orthogonal."
}], "ItemNumbered",
 CellChangeTimes->{{3.7140772869410706`*^9, 3.714077287677371*^9}, {
  3.714077355319442*^9, 
  3.714077663111459*^9}},ExpressionUUID->"2fab7bf7-16fd-436a-92a7-\
348f8061c56b"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
     OverscriptBox["b", "\[RightVector]"]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"(", "3", ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", "2", ")"}], 
       RowBox[{"(", "4", ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", "5", ")"}], 
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}]}]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], "+", "8", "-", "5"}], "=", "0"}]}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f55ff75c-cfee-43d0-a5a4-253242567463"],
 ", so the vectors are orthogonal."
}], "ItemNumbered",
 CellChangeTimes->{{3.7140772869410706`*^9, 3.714077287677371*^9}, {
  3.714077355319442*^9, 
  3.714077724152842*^9}},ExpressionUUID->"e99921d2-15c5-4152-8bd8-\
cb5d4f9a4ece"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
     OverscriptBox["b", "\[RightVector]"]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", "2", ")"}], 
       RowBox[{"(", 
        RowBox[{"-", "3"}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", "6", ")"}], 
       RowBox[{"(", 
        RowBox[{"-", "9"}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "4"}], ")"}], 
       RowBox[{"(", "6", ")"}]}]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], "-", "54", "-", "24"}], "=", 
      RowBox[{"-", "84"}]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "96d11f39-545f-43ce-8850-f2cc999a1b2d"],
 ", so the vectors are not orthogonal. However, notice that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["3", "2"]}], 
     OverscriptBox["a", "\[RightVector]"]}], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "2"]}], 
        RowBox[{"(", "2", ")"}]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "2"]}], 
        RowBox[{"(", "6", ")"}]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "2"]}], 
        RowBox[{"(", 
         RowBox[{"-", "4"}], ")"}]}]}], "\[RightAngleBracket]"}], "=", 
     RowBox[{
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{
        RowBox[{"-", "3"}], ",", 
        RowBox[{"-", "9"}], ",", "6"}], "\[RightAngleBracket]"}], "=", 
      OverscriptBox["b", "\[RightVector]"]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "1b1f3549-c862-49bd-b674-e5a6f47fe5be"],
 ", so the vectors are parallel."
}], "ItemNumbered",
 CellChangeTimes->{{3.7140772869410706`*^9, 3.714077287677371*^9}, {
  3.714077355319442*^9, 
  3.714077871938043*^9}},ExpressionUUID->"fc27e87f-5ad9-4429-8aca-\
7f95b9105e30"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 5", "Section",
 CellChangeTimes->{{3.7132360117278037`*^9, 3.7132360131111164`*^9}, 
   3.713236527279331*^9},ExpressionUUID->"8a849707-7d64-4ab6-84bd-\
d2ca7003e56a"],

Cell[TextData[{
 "Find ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["proj", 
     OverscriptBox["a", "\[RightVector]"]], 
    OverscriptBox["b", "\[RightVector]"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "07bd3cce-676b-49c3-a88a-6c0801eada2c"],
 " for the following pairs of vectors:"
}], "Text",
 CellChangeTimes->{{3.7132365476937985`*^9, 3.713236605121499*^9}, {
   3.7136468336609907`*^9, 3.7136468362360744`*^9}, {3.7136469530118275`*^9, 
   3.7136469884451237`*^9}, {3.713647080759206*^9, 3.713647095429121*^9}, {
   3.71364721831068*^9, 3.7136472292706084`*^9}, 3.7138335573096704`*^9, {
   3.713833824080535*^9, 3.7138338623458776`*^9}, 
   3.7138339340870676`*^9},ExpressionUUID->"d0a72e3d-74b0-4b4a-8ba4-\
78752449ee25"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"1", ",", "4"}], "\[RightAngleBracket]"}]}], ",", " ", 
   RowBox[{
    OverscriptBox["b", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"2", ",", "3"}], "\[RightAngleBracket]"}]}]}], 
  TraditionalForm]],ExpressionUUID->"9f4180fb-7c1b-43a1-96e4-fd2f40fc2fea"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132365476937985`*^9, 3.713236605121499*^9}, {
   3.7136468336609907`*^9, 3.7136468362360744`*^9}, {3.7136469530118275`*^9, 
   3.7136469884451237`*^9}, {3.713647080759206*^9, 3.713647095429121*^9}, {
   3.71364721831068*^9, 3.7136472292706084`*^9}, 3.7138335573096704`*^9, {
   3.713833824080535*^9, 3.7138338623458776`*^9}, {3.7138339630316677`*^9, 
   3.713833978484583*^9}, {3.714068258967509*^9, 3.7140682688155003`*^9}, {
   3.7140779002500353`*^9, 
   3.7140779002505355`*^9}},ExpressionUUID->"dc0f9d36-a288-4274-9b06-\
fa1751f9a37c"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"3", ",", "6", ",", 
      RowBox[{"-", "2"}]}], "\[RightAngleBracket]"}]}], ",", " ", 
   RowBox[{
    OverscriptBox["b", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"1", ",", "2", ",", "3"}], "\[RightAngleBracket]"}]}]}], 
  TraditionalForm]],ExpressionUUID->"7a183e6d-8e9c-4fa7-af88-2a96b2363eec"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7132365476937985`*^9, 3.713236605121499*^9}, {
   3.7136468336609907`*^9, 3.7136468362360744`*^9}, {3.7136469530118275`*^9, 
   3.7136469884451237`*^9}, {3.713647080759206*^9, 3.713647095429121*^9}, {
   3.71364721831068*^9, 3.7136472292706084`*^9}, 3.7138335573096704`*^9, {
   3.713833824080535*^9, 3.7138338623458776`*^9}, {3.7138339630316677`*^9, 
   3.7138339968923483`*^9}, {3.714068269640503*^9, 
   3.714068275957802*^9}},ExpressionUUID->"43a94145-6340-4efe-a9a9-\
d6e051cbdf23"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solutions", "Subsection",
 CellChangeTimes->{{3.7140778801929474`*^9, 
  3.714077887599502*^9}},ExpressionUUID->"ac697b12-ef81-4e56-8419-\
2fe88dddd758"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["proj", 
     OverscriptBox["a", "\[RightVector]"]], 
    OverscriptBox["b", "\[RightVector]"]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      FractionBox[
       RowBox[{
        OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
        OverscriptBox["b", "\[RightVector]"]}], 
       RowBox[{
        OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
        OverscriptBox["a", "\[RightVector]"]}]], ")"}], 
     OverscriptBox["a", "\[RightVector]"]}], "=", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"(", "1", ")"}], 
         RowBox[{"(", "2", ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", "4", ")"}], 
         RowBox[{"(", "3", ")"}]}]}], 
       RowBox[{
        SuperscriptBox["1", "2"], "+", 
        SuperscriptBox["4", "2"]}]], 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"1", ",", "4"}], "\[RightAngleBracket]"}]}], "=", 
     RowBox[{
      FractionBox["14", "17"], 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"1", ",", "4"}], "\[RightAngleBracket]"}]}]}]}]}], 
  TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"76b00f98-2f24-4d2f-b12a-5c9094cf4b27"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7140778801929474`*^9, 3.7140778812495966`*^9}, {
  3.7140779740080614`*^9, 3.714078036006706*^9}, {3.7140780988546724`*^9, 
  3.7140781784984827`*^9}},ExpressionUUID->"77cd958c-67fd-4748-ac86-\
873d75e8cd24"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["proj", 
     OverscriptBox["a", "\[RightVector]"]], 
    OverscriptBox["b", "\[RightVector]"]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      FractionBox[
       RowBox[{
        OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
        OverscriptBox["b", "\[RightVector]"]}], 
       RowBox[{
        OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
        OverscriptBox["a", "\[RightVector]"]}]], ")"}], 
     OverscriptBox["a", "\[RightVector]"]}], "=", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"(", "3", ")"}], 
         RowBox[{"(", "1", ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", "6", ")"}], 
         RowBox[{"(", "2", ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}], 
         RowBox[{"(", "3", ")"}]}]}], 
       RowBox[{
        SuperscriptBox["3", "2"], "+", 
        SuperscriptBox["6", "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}], "2"]}]], 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"3", ",", "6", ",", 
        RowBox[{"-", "2"}]}], "\[RightAngleBracket]"}]}], "=", 
     RowBox[{
      FractionBox["9", "49"], 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"3", ",", "6", ",", 
        RowBox[{"-", "2"}]}], "\[RightAngleBracket]"}]}]}]}]}], 
  TraditionalForm]],ExpressionUUID->"20b71ac4-0811-4ab6-bd3d-93b8f9adc43e"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7140778801929474`*^9, 3.7140778812495966`*^9}, {
  3.7140779740080614`*^9, 3.714078036006706*^9}, {3.7140780988546724`*^9, 
  3.7140782535229034`*^9}},ExpressionUUID->"8441abc0-2507-4ca5-8343-\
7052332f4f8c"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 6", "Section",
 CellChangeTimes->{{3.71323602223969*^9, 
  3.713236023623618*^9}},ExpressionUUID->"9b176684-111d-4f29-bacc-\
264336849fa2"],

Cell[TextData[{
 "A tow truck drags a stalled car along a road. The chain makes an angle of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"30", "\[Degree]"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f5db7147-0538-4d1d-9978-49a314cd7f0d"],
 " with the road and the tension in the chain is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1500", "N"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c288d743-661b-48c4-84f4-78a3139afdb2"],
 ". How much work is done by the truck in pulling the car ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "km"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "81e75694-4cae-42c3-b847-63a9d72d8e5a"],
 "?"
}], "Text",
 CellChangeTimes->{{3.71323665278123*^9, 3.713236767453306*^9}, {
  3.7134677776202555`*^9, 3.713467782061041*^9}, {3.713647234575392*^9, 
  3.7136473046399937`*^9}, {3.7138342687292356`*^9, 
  3.7138343325537825`*^9}},ExpressionUUID->"39594a9e-f325-4236-abf3-\
e2f0761de3dd"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714078287785679*^9, 
  3.7140782933679867`*^9}},ExpressionUUID->"0c99a398-207b-474f-9b34-\
a94c49191a5b"],

Cell["\<\
Work is given as the dot product between the force and displacement vectors, \
so\
\>", "Text",
 CellChangeTimes->{{3.714078287785679*^9, 3.714078288553995*^9}, {
  3.7140784388502636`*^9, 
  3.7140784651022863`*^9}},ExpressionUUID->"3dc9f0f9-ac9e-46b2-ad5e-\
b20bb6d20260"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"W", "=", 
   RowBox[{
    RowBox[{"||", 
     OverscriptBox["F", "\[RightVector]"], "||", " ", "||", 
     OverscriptBox["d", "\[RightVector]"], "||", " ", 
     RowBox[{"cos", " ", "\[Theta]"}]}], " ", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1500", " ", "N"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"1", "km"}], ")"}], "cos", " ", "30", "\[Degree]"}], "=", 
     RowBox[{
      RowBox[{"1500", "kJ", " ", 
       RowBox[{"(", 
        FractionBox[
         SqrtBox["3"], "2"], ")"}]}], "=", 
      RowBox[{
       RowBox[{"750", 
        SqrtBox["3"], "kJ"}], "\[TildeTilde]", 
       RowBox[{"1299.04", "kJ"}]}]}]}]}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"b4aa7b49-6530-4bc3-91c1-c7f6430d1ed5"]], \
"Text",
 CellChangeTimes->{{3.714078287785679*^9, 3.714078288553995*^9}, {
  3.7140784388502636`*^9, 3.714078600346936*^9}},
 TextAlignment->Center,ExpressionUUID->"6d40ffe8-be57-40da-8f20-dc3ba187d32a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 7", "Section",
 CellChangeTimes->{{3.713236026463976*^9, 
  3.7132360275922284`*^9}},ExpressionUUID->"213b8a14-dd5d-4c8b-839d-\
d0746db10921"],

Cell[TextData[{
 "A molecule of methane, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["CH", "4"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "1d6513fb-1033-4dc6-a61c-94e438c7ea1e"],
 ", is structured with the four hydrogen atoms at the vertices of a regular \
tetrahedron and the carbon atom at the centroid. The ",
 StyleBox["bond angle",
  FontSlant->"Italic"],
 " is the angle formed by the H--C--H combination; it is the angle between \
the lines that joins the carbon atom to two of the hydrogen atoms. Show that \
the bond angle is about ",
 Cell[BoxData[
  FormBox[
   RowBox[{"109.5", "\[Degree]"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c08e012e-009c-460f-bea1-d16846cd950d"],
 ". (",
 StyleBox["Hint:",
  FontSlant->"Italic"],
 " Take the vertices of the tetrahedron to be the points ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"1", ",", "0", ",", "0"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "8c68e36b-adbf-4739-b93c-c2fe30cfb1dc"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "1", ",", "0"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "7f97c896-bcdf-4def-b7e8-0b2890cb1a6d"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "0", ",", "1"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "544e70ab-37f4-4262-9f79-dc83cb26dc11"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"1", ",", "1", ",", "1"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e6db2cea-68d4-4619-a1af-b95eb8c1bd37"],
 ", as shown in the figure below. Then the centroid is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"]}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "1b99ff7b-b749-4d57-80cb-3c324e6e2a74"],
 ".)"
}], "Text",
 CellChangeTimes->{{3.7132367787251453`*^9, 3.7132368234142118`*^9}, 
   3.713236878664731*^9, {3.713468976067685*^9, 3.713468976067685*^9}, 
   3.7136476819867496`*^9, {3.7136480727489834`*^9, 3.7136480756513257`*^9}, {
   3.7136482157401752`*^9, 3.713648255587457*^9}, {3.7136482910770264`*^9, 
   3.713648335588113*^9}, {3.7136486123195176`*^9, 3.7136487071242495`*^9}, {
   3.7136516126116576`*^9, 3.7136516678198004`*^9}, {3.7136518137644463`*^9, 
   3.713652113941457*^9}, {3.7138344195303154`*^9, 
   3.713834609225483*^9}},ExpressionUUID->"140bdf55-ab75-4f74-9e26-\
7f21c5377a32"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"in1", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Arrowheads", "[", "0", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"Tube", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "/", "2"}], ",", 
             RowBox[{"1", "/", "2"}], ",", 
             RowBox[{"1", "/", "2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", "0.005"}],
         "]"}], "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"in2", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Arrowheads", "[", "0", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"Tube", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "/", "2"}], ",", 
             RowBox[{"1", "/", "2"}], ",", 
             RowBox[{"1", "/", "2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", "0.005"}],
         "]"}], "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"in3", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Arrowheads", "[", "0", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"Tube", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "/", "2"}], ",", 
             RowBox[{"1", "/", "2"}], ",", 
             RowBox[{"1", "/", "2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", "0.005"}],
         "]"}], "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"in4", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Arrowheads", "[", "0", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"Tube", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "/", "2"}], ",", 
             RowBox[{"1", "/", "2"}], ",", 
             RowBox[{"1", "/", "2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", "0.005"}],
         "]"}], "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"out1", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Dashed", ",", 
      RowBox[{"Arrowheads", "[", "0", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"out2", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Dashed", ",", 
      RowBox[{"Arrowheads", "[", "0", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"out3", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Dashed", ",", 
      RowBox[{"Arrowheads", "[", "0", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"out4", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Dashed", ",", 
      RowBox[{"Arrowheads", "[", "0", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"out5", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Dashed", ",", 
      RowBox[{"Arrowheads", "[", "0", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"out6", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Dashed", ",", 
      RowBox[{"Arrowheads", "[", "0", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"carbon", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "0.1", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", 
         RowBox[{"1", "/", "2"}], ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hydrogen", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Purple", ",", 
      RowBox[{"PointSize", "[", "0.03571428571428572", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
  "in1", ",", "in2", ",", "in3", ",", "in4", ",", "out1", ",", "out2", ",", 
   "out3", ",", "out4", ",", "out5", ",", "out6", ",", "carbon", ",", 
   "hydrogen", ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.1"}], ",", "1.2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.1"}], ",", "1.2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.1"}], ",", "1.2"}], "}"}]}], "}"}]}]}], 
  "]"}]}], "Input",
 CellOpen->False,
 CellChangeTimes->{{3.7138346504943347`*^9, 
  3.713834650881694*^9}},ExpressionUUID->"20a74435-fdcc-4594-b195-\
1a3009b5ac48"],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 0, 0], Arrowheads[0], 
    Arrow3DBox[TubeBox[
     NCache[{{Rational[1, 2], Rational[1, 2], Rational[1, 2]}, {1, 1, 1}}, {{
       0.5, 0.5, 0.5}, {1, 1, 1}}], 0.005]]}, 
   {RGBColor[1, 0, 0], Arrowheads[0], 
    Arrow3DBox[TubeBox[
     NCache[{{Rational[1, 2], Rational[1, 2], Rational[1, 2]}, {1, 0, 0}}, {{
       0.5, 0.5, 0.5}, {1, 0, 0}}], 0.005]]}, 
   {RGBColor[1, 0, 0], Arrowheads[0], 
    Arrow3DBox[TubeBox[
     NCache[{{Rational[1, 2], Rational[1, 2], Rational[1, 2]}, {0, 1, 0}}, {{
       0.5, 0.5, 0.5}, {0, 1, 0}}], 0.005]]}, 
   {RGBColor[1, 0, 0], Arrowheads[0], 
    Arrow3DBox[TubeBox[
     NCache[{{Rational[1, 2], Rational[1, 2], Rational[1, 2]}, {0, 0, 1}}, {{
       0.5, 0.5, 0.5}, {0, 0, 1}}], 0.005]]}, 
   {RGBColor[0, 0, 1], Dashing[{Small, Small}], Arrowheads[0], 
    Arrow3DBox[{{1, 1, 1}, {1, 0, 0}}]}, 
   {RGBColor[0, 0, 1], Dashing[{Small, Small}], Arrowheads[0], 
    Arrow3DBox[{{1, 1, 1}, {0, 1, 0}}]}, 
   {RGBColor[0, 0, 1], Dashing[{Small, Small}], Arrowheads[0], 
    Arrow3DBox[{{1, 1, 1}, {0, 0, 1}}]}, 
   {RGBColor[0, 0, 1], Dashing[{Small, Small}], Arrowheads[0], 
    Arrow3DBox[{{0, 1, 0}, {1, 0, 0}}]}, 
   {RGBColor[0, 0, 1], Dashing[{Small, Small}], Arrowheads[0], 
    Arrow3DBox[{{0, 0, 1}, {0, 1, 0}}]}, 
   {RGBColor[0, 0, 1], Dashing[{Small, Small}], Arrowheads[0], 
    Arrow3DBox[{{1, 0, 0}, {0, 0, 1}}]}, 
   {PointSize[0.1], 
    Point3DBox[
     NCache[{Rational[1, 2], Rational[1, 2], Rational[1, 2]}, {0.5, 0.5, 
      0.5}]]}, 
   {RGBColor[0.5, 0, 0.5], PointSize[0.03571428571428572], 
    Point3DBox[{1, 0, 0}], Point3DBox[{0, 1, 0}], Point3DBox[{0, 0, 1}], 
    Point3DBox[{1, 1, 1}]}},
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["z", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  ImageSize->{340.508738747303, 401.2129110311813},
  ImageSizeRaw->Automatic,
  PlotRange->{{-0.1, 1.2}, {-0.1, 1.2}, {-0.1, 1.2}},
  ViewPoint->{2.039436050916367, 0.11733504972766118`, 2.697579114748641},
  ViewVertical->{-0.2864225555478004, 0.08660888962137511, 
   0.9541808109116531}]], "Output",
 CellChangeTimes->{
  3.7138346541023655`*^9},ExpressionUUID->"09c52039-9948-429c-aa29-\
94a053abe6cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7140786299205236`*^9, 
  3.714078632119571*^9}},ExpressionUUID->"c54946ca-f43b-4422-878e-\
238e555d2002"],

Cell["\<\
We are looking for the angle between the red lines (bonds). Since they\
\[CloseCurlyQuote]re all the same, we just need to create vectors \
representing two of them, then find the angle between them.\
\>", "Text",
 CellChangeTimes->{{3.7140786299205236`*^9, 
  3.7140786800714755`*^9}},ExpressionUUID->"2510a53a-7b56-4b53-96aa-\
92835b427e01"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{GridBox[{
           {
            RowBox[{
             SubscriptBox[
              OverscriptBox["v", "\[RightVector]"], "1"], "=", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", ",", "1", ",", "1"}], ")"}], "-", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "2"], ",", 
                FractionBox["1", "2"], ",", 
                FractionBox["1", "2"]}], ")"}]}]}]}
          },
          GridBoxAlignment->{"Columns" -> {{"="}}}], "=", 
         RowBox[{"\[LeftAngleBracket]", 
          RowBox[{
           FractionBox["1", "2"], ",", 
           FractionBox["1", "2"], ",", 
           FractionBox["1", "2"]}], "\[RightAngleBracket]"}]}]},
       {
        RowBox[{GridBox[{
           {
            RowBox[{
             SubscriptBox[
              OverscriptBox["v", "\[RightVector]"], "2"], "=", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", ",", "0", ",", "0"}], ")"}], "-", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "2"], ",", 
                FractionBox["1", "2"], ",", 
                FractionBox["1", "2"]}], ")"}]}]}]}
          },
          GridBoxAlignment->{"Columns" -> {{"="}}}], "=", 
         RowBox[{"\[LeftAngleBracket]", 
          RowBox[{
           FractionBox["1", "2"], ",", 
           RowBox[{"-", 
            FractionBox["1", "2"]}], ",", 
           RowBox[{"-", 
            FractionBox["1", "2"]}]}], "\[RightAngleBracket]"}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"="}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"d3f09832-96e8-4808-bca7-b31cb38e4e0c"]], \
"Text",
 CellChangeTimes->{{3.7140787784646106`*^9, 
  3.714078928267394*^9}},ExpressionUUID->"a72700f8-8363-4be0-b379-\
efcd1f532234"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox[
      OverscriptBox["v", "\[RightVector]"], "1"], "\[CenterDot]", 
     SubscriptBox[
      OverscriptBox["v", "\[RightVector]"], "2"]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        FractionBox["1", "2"], ")"}], 
       RowBox[{"(", 
        FractionBox["1", "2"], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        FractionBox["1", "2"], ")"}], 
       RowBox[{"(", 
        RowBox[{"-", 
         FractionBox["1", "2"]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        FractionBox["1", "2"], ")"}], 
       RowBox[{"(", 
        RowBox[{"-", 
         FractionBox["1", "2"]}], ")"}]}]}], "=", 
     RowBox[{
      RowBox[{
       FractionBox["1", "4"], "-", 
       FractionBox["1", "4"], "-", 
       FractionBox["1", "4"]}], "=", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d52866d4-5551-4d6d-b33e-e26255905006"],
 "\n",
 Cell[BoxData[{
  FormBox[
   RowBox[{
    RowBox[{"||", 
     SubscriptBox[
      OverscriptBox["v", "\[RightVector]"], "1"], "||"}], "=", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "2"], ")"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "2"], ")"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "2"], ")"}], "2"]}]], "=", 
     RowBox[{
      SqrtBox[
       FractionBox["3", "4"]], "=", 
      FractionBox[
       SqrtBox["3"], "2"]}]}]}], TraditionalForm], "\[IndentingNewLine]", 
  FormBox[
   RowBox[{
    RowBox[{"||", 
     SubscriptBox[
      OverscriptBox["v", "\[RightVector]"], "2"], "||"}], "=", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "2"], ")"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", 
          FractionBox["1", "2"]}], ")"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", 
          FractionBox["1", "2"]}], ")"}], "2"]}]], "=", 
     RowBox[{
      SqrtBox[
       FractionBox["3", "4"]], "=", 
      FractionBox[
       SqrtBox["3"], "2"]}]}]}], TraditionalForm], "\[IndentingNewLine]", 
  FormBox[
   RowBox[{"\[Theta]", "=", 
    RowBox[{
     RowBox[{"arccos", "(", 
      FractionBox[
       RowBox[{"-", 
        FractionBox["1", "4"]}], 
       RowBox[{
        FractionBox[
         SqrtBox["3"], "2"], 
        FractionBox[
         SqrtBox["3"], "2"]}]], ")"}], "=", 
     RowBox[{"arccos", "(", 
      RowBox[{"-", 
       FractionBox["1", "3"]}], ")"}]}]}], TraditionalForm]}],
  FormatType->"TraditionalForm",ExpressionUUID->
  "95a01f88-c352-4a81-a424-714427bcc2f8"]
}], "Text",
 CellChangeTimes->{{3.7140789578377857`*^9, 3.7140791739964204`*^9}},
 TextAlignment->Center,ExpressionUUID->"236ab699-65a4-49d0-9cac-9ac2bc847cc0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"ArcCos", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "/", "3"}], "]"}], "]"}], "*", 
  RowBox[{"(", 
   RowBox[{"180", "/", "\[Pi]"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.7140792021573343`*^9, 
  3.7140792197271605`*^9}},ExpressionUUID->"132120e3-fa36-4f1b-a2d8-\
edfc16c6e16c"],

Cell[BoxData["109.47122063449069`"], "Output",
 CellChangeTimes->{
  3.7140792210596733`*^9},ExpressionUUID->"51056486-5a88-4cb7-af63-\
9b42e202768c"]
}, Open  ]],

Cell[TextData[{
 "So we see that the angle measure is about ",
 Cell[BoxData[
  FormBox[
   RowBox[{"109.5", "\[Degree]"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "812562b1-d1f7-4a2d-a151-0b84922e05f0"],
 "."
}], "Text",
 CellChangeTimes->{{3.714079223732545*^9, 
  3.714079238107664*^9}},ExpressionUUID->"8e734cb5-01d5-41f7-bcb7-\
39c0a72fefc9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 8", "Section",
 CellChangeTimes->{{3.713236030488112*^9, 3.7132360333433156`*^9}},
 TextAlignment->Left,ExpressionUUID->"cf29a0ce-5007-4b71-bb63-1b977e8b9418"],

Cell[TextData[{
 "Show that the vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["orth", 
      OverscriptBox["a", "\[RightVector]"]], 
     OverscriptBox["b", "\[RightVector]"]}], "=", 
    RowBox[{
     OverscriptBox["b", "\[RightVector]"], "-", 
     RowBox[{
      SubscriptBox["proj", 
       OverscriptBox["a", "\[RightVector]"]], 
      OverscriptBox["b", "\[RightVector]"]}]}]}], TraditionalForm]],
  ExpressionUUID->"c3a97cff-7a22-498a-90fc-2f17b7bcfd2d"],
 " is orthogonal to ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["a", "\[RightVector]"], TraditionalForm]],ExpressionUUID->
  "b6e40b09-534e-4db6-ad6c-4ee2a11a27e1"],
 ". (This vector is called an ",
 StyleBox["orthogonal projection",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["b", "\[RightVector]"], TraditionalForm]],ExpressionUUID->
  "e0f6606b-e565-45ba-ad0c-17c7c8d37bda"],
 ".) Illustrate this vector by plotting ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["a", "\[RightVector]"], TraditionalForm]],ExpressionUUID->
  "05efe7fd-c923-4fa0-a5bf-437836a3c350"],
 ", ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["b", "\[RightVector]"], TraditionalForm]],ExpressionUUID->
  "b4b05da7-6a59-4680-90dc-376d33729aa7"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["proj", 
     OverscriptBox["a", "\[RightVector]"]], 
    OverscriptBox["b", "\[RightVector]"]}], TraditionalForm]],ExpressionUUID->
  "a11dfb33-89d6-484b-aaea-f224c35bfa89"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["orth", 
     OverscriptBox["a", "\[RightVector]"]], 
    OverscriptBox["b", "\[RightVector]"]}], TraditionalForm]],ExpressionUUID->
  "c7477f42-94a2-4f3d-91d8-cb5f712dbbb5"],
 " together."
}], "Text",
 CellChangeTimes->{{3.713236916043934*^9, 3.7132369632722015`*^9}, 
   3.7134689836990843`*^9, {3.713648970245249*^9, 3.7136489768366575`*^9}, {
   3.7136490086305647`*^9, 3.7136490799425354`*^9}, {3.7138348972093554`*^9, 
   3.7138350920889792`*^9}},ExpressionUUID->"38d79a8b-e7bf-4b29-979b-\
d991b5a53423"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714079893464075*^9, 
  3.7140798995106397`*^9}},ExpressionUUID->"467fdfa8-5d3a-4d33-833e-\
a9b47cb3e541"],

Cell["This is basically a straight computation", "Text",
 CellChangeTimes->{{3.714079893464075*^9, 
  3.7140799180228014`*^9}},ExpressionUUID->"a5522b5e-a538-4b2c-9486-\
4be11c34f03c"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["orth", 
             OverscriptBox["a", "\[RightVector]"]], 
            OverscriptBox["b", "\[RightVector]"]}], ")"}], "\[CenterDot]", 
          OverscriptBox["a", "\[RightVector]"]}], "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            OverscriptBox["b", "\[RightVector]"], "-", 
            RowBox[{
             RowBox[{"(", 
              FractionBox[
               RowBox[{
                OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
                OverscriptBox["b", "\[RightVector]"]}], 
               RowBox[{
                OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
                OverscriptBox["a", "\[RightVector]"]}]], ")"}], 
             OverscriptBox["a", "\[RightVector]"]}]}], ")"}], "\[CenterDot]", 
          OverscriptBox["a", "\[RightVector]"]}]}]},
       {
        RowBox[{"=", 
         RowBox[{
          RowBox[{
           OverscriptBox["b", "\[RightVector]"], "\[CenterDot]", 
           OverscriptBox["a", "\[RightVector]"]}], "-", 
          RowBox[{
           RowBox[{"(", 
            FractionBox[
             RowBox[{
              OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
              OverscriptBox["b", "\[RightVector]"]}], 
             RowBox[{
              OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
              OverscriptBox["a", "\[RightVector]"]}]], ")"}], 
           RowBox[{
            OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
            OverscriptBox["a", "\[RightVector]"]}]}]}]}]},
       {
        RowBox[{"=", 
         RowBox[{
          RowBox[{
           RowBox[{
            OverscriptBox["b", "\[RightVector]"], "\[CenterDot]", 
            OverscriptBox["a", "\[RightVector]"]}], "-", 
           RowBox[{
            OverscriptBox["a", "\[RightVector]"], "\[CenterDot]", 
            OverscriptBox["b", "\[RightVector]"]}]}], "=", "0"}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"="}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"2ce7a02d-cd18-4739-b1bc-ee8db6e99f70"]], \
"Text",
 CellChangeTimes->{{3.7140799282622547`*^9, 
  3.7140800651561065`*^9}},ExpressionUUID->"5e22cc83-6d9c-44de-8c89-\
0d706238e420"],

Cell["To plot an example, let\[CloseCurlyQuote]s use our vectors from problem \
5a.", "Text",
 CellChangeTimes->{{3.7140801311234026`*^9, 
  3.7140801509738846`*^9}},ExpressionUUID->"f2b69d90-766c-46f4-a72d-\
2a2e9bcabf4e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"veca", ",", "vecb", ",", "proj", ",", "orth"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"veca", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "4"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\!\(\*OverscriptBox[\(a\), \(\[RightVector]\)]\)\>\"", ",", 
          "Large"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4.2"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vecb", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\!\(\*OverscriptBox[\(b\), \(\[RightVector]\)]\)\>\"", ",", 
          "Large"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3.2"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"proj", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Purple", ",", "Thick", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"14", "/", "17"}], ",", 
           RowBox[{"4", 
            RowBox[{"(", 
             RowBox[{"14", "/", "17"}], ")"}]}]}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\!\(TraditionalForm\`\*SubscriptBox[\(proj\), OverscriptBox[\(a\
\), \(\[RightVector]\)]] \*OverscriptBox[\(b\), \(\[RightVector]\)]\)\>\"", 
          ",", "Large"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"5", "/", "17"}], ",", 
          RowBox[{"56", "/", "17"}]}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"orth", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Green", ",", "Thick", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"20", "/", "17"}], ",", 
           RowBox[{
            RowBox[{"-", "5"}], "/", "17"}]}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\!\(TraditionalForm\`\*SubscriptBox[\(orth\), OverscriptBox[\(a\
\), \(\[RightVector]\)]] \*OverscriptBox[\(b\), \(\[RightVector]\)]\)\>\"", 
          ",", "Large"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"20", "/", "17"}], ",", 
          RowBox[{
           RowBox[{"-", "8"}], "/", "17"}]}], "}"}]}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"veca", ",", "vecb", ",", "proj", ",", "orth"}], "]"}]}], "Input",
 CellChangeTimes->{{3.7140801586308813`*^9, 3.7140802985792985`*^9}, {
  3.714080349067025*^9, 3.7140803618500223`*^9}, {3.7140803939363227`*^9, 
  3.7140804723030505`*^9}, {3.7140805051742516`*^9, 3.714080712108449*^9}, {
  3.714081213776415*^9, 
  3.7140812140621204`*^9}},ExpressionUUID->"5abd2656-3fb6-4cd8-b9af-\
4d0a69bab197"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], ArrowBox[{{0, 0}, {1, 4}}], InsetBox[
     StyleBox["\<\"\\!\\(\\*OverscriptBox[\\(a\\), \\(\[RightVector]\\)]\\)\"\
\>",
      StripOnInput->False,
      FontSize->Large], {1, 4.2}]}, 
   {RGBColor[1, 0, 0], ArrowBox[{{0, 0}, {2, 3}}], InsetBox[
     StyleBox["\<\"\\!\\(\\*OverscriptBox[\\(b\\), \\(\[RightVector]\\)]\\)\"\
\>",
      StripOnInput->False,
      FontSize->Large], {2, 3.2}]}, 
   {RGBColor[0.5, 0, 0.5], Thickness[Large], 
    ArrowBox[NCache[{{0, 0}, {Rational[14, 17], Rational[56, 17]}}, {{0, 0}, {
       0.8235294117647058, 3.2941176470588234`}}]], InsetBox[
     StyleBox["\<\"\\!\\(TraditionalForm\\`\\*SubscriptBox[\\(proj\\), \
OverscriptBox[\\(a\\), \\(\[RightVector]\\)]] \\*OverscriptBox[\\(b\\), \\(\
\[RightVector]\\)]\\)\"\>",
      StripOnInput->False,
      FontSize->Large], 
     NCache[{Rational[5, 17], Rational[56, 17]}, {0.29411764705882354`, 
      3.2941176470588234`}]]}, 
   {RGBColor[0, 1, 0], Thickness[Large], 
    ArrowBox[NCache[{{0, 0}, {Rational[20, 17], Rational[-5, 17]}}, {{0, 0}, {
       1.1764705882352942`, -0.29411764705882354`}}]], InsetBox[
     StyleBox["\<\"\\!\\(TraditionalForm\\`\\*SubscriptBox[\\(orth\\), \
OverscriptBox[\\(a\\), \\(\[RightVector]\\)]] \\*OverscriptBox[\\(b\\), \\(\
\[RightVector]\\)]\\)\"\>",
      StripOnInput->False,
      FontSize->Large], 
     NCache[{Rational[20, 17], Rational[-8, 17]}, {
      1.1764705882352942`, -0.47058823529411764`}]]}}]], "Output",
 CellChangeTimes->{
  3.7140803634331455`*^9, {3.714080434879423*^9, 3.7140804688490295`*^9}, {
   3.7140805239899263`*^9, 3.714080541830003*^9}, 3.714080574224801*^9, {
   3.714080630090001*^9, 3.714080664479083*^9}, {3.7140807059990053`*^9, 
   3.714080712847636*^9}, 
   3.714081214707814*^9},ExpressionUUID->"1a6d80ae-4fa7-4417-8e9d-\
2351759bf0ad"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 9 (Little Challenge)", "Section",
 CellChangeTimes->{{3.7132360358875327`*^9, 3.7132360371682196`*^9}, {
  3.7138351070164747`*^9, 3.7138351098009634`*^9}, {3.713835634716791*^9, 
  3.7138356364700127`*^9}, {3.7138359316568527`*^9, 3.71383593260792*^9}, {
  3.713872640299595*^9, 
  3.7138726413837233`*^9}},ExpressionUUID->"ff456d06-769e-4034-bf66-\
53c4343af8ab"],

Cell[TextData[{
 "Use the definition of the dot product involving the angle between the \
vectors ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["u", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "a0e0f478-62cc-4502-8e3e-030e6cb8d959"],
 " and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["v", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "6f88931f-b0de-4f9a-9252-e8467c238009"],
 " to prove the ",
 StyleBox["Cauchy-Schwarz Inequality",
  FontSlant->"Italic"],
 ":"
}], "Text",
 CellChangeTimes->{{3.713236968060338*^9, 3.7132369811442337`*^9}, {
  3.713238103378575*^9, 3.7132381044433203`*^9}, {3.7136491318222866`*^9, 
  3.7136491741507063`*^9}, {3.713649210263423*^9, 3.7136492725515833`*^9}, {
  3.713835130857093*^9, 3.7138351684036684`*^9}, {3.7138352463860474`*^9, 
  3.713835255997469*^9}},ExpressionUUID->"95b56bc2-8c0d-47d9-8d6c-\
692117207b10"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"|", 
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "\[CenterDot]", 
    OverscriptBox["v", "\[RightVector]"]}], "|", " ", 
   RowBox[{"\[LessEqual]", 
    RowBox[{"||", 
     OverscriptBox["u", "\[RightVector]"], "||", " ", "||", 
     OverscriptBox["v", "\[RightVector]"], "||"}]}]}], 
  TraditionalForm]],ExpressionUUID->"2b5ec443-0295-4edb-abcd-2e5e0ecba393"]], \
"Text",
 CellChangeTimes->{{3.713236968060338*^9, 3.7132369811442337`*^9}, {
  3.713238103378575*^9, 3.7132381044433203`*^9}, {3.7136491318222866`*^9, 
  3.7136491741507063`*^9}, {3.713649210263423*^9, 3.7136492725515833`*^9}, {
  3.713835130857093*^9, 3.713835221345162*^9}, {3.713885636157596*^9, 
  3.713885637956046*^9}},
 TextAlignment->Center,ExpressionUUID->"36ec7416-54f4-48f6-ad36-e914763425aa"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714081241629292*^9, 
  3.714081246582762*^9}},ExpressionUUID->"813e0d9e-72d5-4cfb-a2fc-\
7d265c87e951"],

Cell["", "Text",
 CellChangeTimes->{{3.714081241629292*^9, 
  3.7140812425805864`*^9}},ExpressionUUID->"7d141712-8072-447c-b876-\
4e55eda69c7d"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{"|", 
       RowBox[{
        OverscriptBox["u", "\[RightVector]"], "\[CenterDot]", 
        OverscriptBox["v", "\[RightVector]"]}], "|"}], "=", 
      RowBox[{
       RowBox[{"|", " ", 
        RowBox[{"||", 
         OverscriptBox["u", "\[RightVector]"], "||", " ", "||", 
         OverscriptBox["v", "\[RightVector]"], "||", " ", 
         RowBox[{"cos", " ", "\[Theta]"}]}], " ", "|"}], "=", 
       RowBox[{
        RowBox[{"||", 
         OverscriptBox["u", "\[RightVector]"], "||", " ", "||", 
         OverscriptBox["v", "\[RightVector]"], "||"}], " ", "|", 
        RowBox[{"cos", " ", "\[Theta]"}], " ", "|", 
        RowBox[{"\[LessEqual]", 
         RowBox[{"||", 
          OverscriptBox["u", "\[RightVector]"], "||", " ", "||", 
          OverscriptBox["v", "\[RightVector]"], "||"}]}]}]}]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"579783f2-1cc5-43bd-a1da-eee3c85be8ac"]], \
"Text",
 CellChangeTimes->{{3.714081258912746*^9, 3.714081462729295*^9}, {
  3.7140818882098684`*^9, 
  3.7140818895604715`*^9}},ExpressionUUID->"055a6abe-2e78-42c1-9b88-\
3ed72280d373"],

Cell[TextData[{
 "since ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"cos", " ", "\[Theta]"}], "|", 
    RowBox[{"\[LessEqual]", "1"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "25839227-2c16-4fbf-b7d9-43f4258049c2"],
 "."
}], "Text",
 CellChangeTimes->{{3.714081465527724*^9, 
  3.7140814848813553`*^9}},ExpressionUUID->"eb5dba3a-49de-4fce-a76e-\
6c0a91458638"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 10 (Little Challenge)", "Section",
 CellChangeTimes->{{3.713236039199822*^9, 3.7132360418072557`*^9}, {
   3.7138352647782273`*^9, 3.7138352666392584`*^9}, {3.7138356392449474`*^9, 
   3.7138356401173787`*^9}, {3.7138359296564264`*^9, 3.7138359306489773`*^9}, 
   3.713872646196253*^9},ExpressionUUID->"bdb4b9e4-e0e4-4ab5-bc41-\
4532cfdc2790"],

Cell[TextData[{
 "The ",
 StyleBox["Triangle Inequality",
  FontSlant->"Italic"],
 " for vectors is"
}], "Text",
 CellChangeTimes->{{3.7132369896523333`*^9, 3.7132370256061144`*^9}, {
  3.7136498172118177`*^9, 3.7136499154061193`*^9}, {3.713650060006056*^9, 
  3.713650102742618*^9}, {3.7136502356555223`*^9, 3.713650311688095*^9}, {
  3.713835323378643*^9, 
  3.713835337239922*^9}},ExpressionUUID->"f48cc877-c2e7-452b-a207-\
13fd886100f0"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"||", 
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "+", 
    OverscriptBox["v", "\[RightVector]"]}], "||", 
   RowBox[{"\[LessEqual]", 
    RowBox[{"||", 
     OverscriptBox["u", "\[RightVector]"], "||", " ", 
     RowBox[{"+", " ", 
      RowBox[{"||", 
       OverscriptBox["v", "\[RightVector]"], "||"}]}]}]}]}], 
  TraditionalForm]],ExpressionUUID->"9556b68c-f000-41b2-a74a-c7818d628356"]], \
"Text",
 CellChangeTimes->{{3.7132369896523333`*^9, 3.7132370256061144`*^9}, {
  3.7136498172118177`*^9, 3.7136499154061193`*^9}, {3.713650060006056*^9, 
  3.713650102742618*^9}, {3.7136502356555223`*^9, 3.713650311688095*^9}, {
  3.713835323378643*^9, 3.7138353870958624`*^9}},
 TextAlignment->Center,ExpressionUUID->"15b1e942-30c7-413c-af56-225871f31ef6"],

Cell[TextData[{
 "Use the fact that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"||", 
     RowBox[{
      OverscriptBox["u", "\[RightVector]"], "+", 
      OverscriptBox["v", "\[RightVector]"]}], 
     SuperscriptBox["||", "2"]}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       OverscriptBox["u", "\[RightVector]"], "+", 
       OverscriptBox["v", "\[RightVector]"]}], ")"}], "\[CenterDot]", 
     RowBox[{"(", 
      RowBox[{
       OverscriptBox["u", "\[RightVector]"], "+", 
       OverscriptBox["v", "\[RightVector]"]}], ")"}]}]}], TraditionalForm]],
  ExpressionUUID->"1f383e75-4aaa-4516-b7b9-429104a5b4b6"],
 " and the Cauchy-Schwarz inequality to prove the triangle inequality."
}], "Text",
 CellChangeTimes->{{3.7132369896523333`*^9, 3.7132370256061144`*^9}, {
  3.7136498172118177`*^9, 3.7136499154061193`*^9}, {3.713650060006056*^9, 
  3.713650102742618*^9}, {3.7136502356555223`*^9, 3.713650311688095*^9}, {
  3.713835323378643*^9, 
  3.7138354941164265`*^9}},ExpressionUUID->"2f4261bd-3bbd-41b3-ad61-\
46aa670c125b"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7140814962658443`*^9, 
  3.71408150024344*^9}},ExpressionUUID->"c506ca52-b30e-498b-ac44-\
5bc3ec2966b8"],

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{"||", 
    RowBox[{
     OverscriptBox["u", "\[RightVector]"], "+", 
     OverscriptBox["v", "\[RightVector]"]}], 
    SuperscriptBox["||", "2"]}], "\[AlignmentMarker]", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["u", "\[RightVector]"], "+", 
      OverscriptBox["v", "\[RightVector]"]}], ")"}], "\[CenterDot]", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["u", "\[RightVector]"], "+", 
      OverscriptBox["v", "\[RightVector]"]}], ")"}]}]}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"                         ", 
   RowBox[{"=", 
    RowBox[{
     RowBox[{
      OverscriptBox["u", "\[RightVector]"], "\[CenterDot]", 
      OverscriptBox["u", "\[RightVector]"]}], "+", 
     RowBox[{
      OverscriptBox["u", "\[RightVector]"], "\[CenterDot]", 
      OverscriptBox["v", "\[RightVector]"]}], "+", 
     RowBox[{
      OverscriptBox["v", "\[RightVector]"], "\[CenterDot]", 
      OverscriptBox["u", "\[RightVector]"]}], "+", 
     RowBox[{
      OverscriptBox["v", "\[RightVector]"], "\[CenterDot]", 
      OverscriptBox["v", "\[RightVector]"]}]}]}]}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"                         ", 
   RowBox[{"=", 
    RowBox[{
     RowBox[{
      RowBox[{"||", 
       OverscriptBox["u", "\[RightVector]"], 
       SuperscriptBox["||", "2"], 
       RowBox[{
        RowBox[{
         RowBox[{"+", " ", "2"}], 
         RowBox[{
          OverscriptBox["u", "\[RightVector]"], "\[CenterDot]", 
          OverscriptBox["v", "\[RightVector]"]}]}], "+"}], "||", 
       OverscriptBox["v", "\[RightVector]"], 
       SuperscriptBox["||", "2"], "\[IndentingNewLine]", "          ", 
       RowBox[{"\[LessEqual]", 
        RowBox[{"||", 
         OverscriptBox["u", "\[RightVector]"], 
         SuperscriptBox["||", "2"], 
         RowBox[{"+", " ", "2"}]}]}]}], "|", 
      RowBox[{
       OverscriptBox["u", "\[RightVector]"], "\[CenterDot]", 
       OverscriptBox["v", "\[RightVector]"]}], "|", 
      RowBox[{"+", 
       RowBox[{"||", 
        OverscriptBox["v", "\[RightVector]"], 
        SuperscriptBox["||", "2"], "\[IndentingNewLine]", "  ", 
        RowBox[{"\[LessEqual]", 
         RowBox[{"||", 
          OverscriptBox["u", "\[RightVector]"], 
          SuperscriptBox["||", "2"], 
          RowBox[{"+", " ", "2"}], "||", 
          OverscriptBox["u", "\[RightVector]"], "||", " ", "||", 
          OverscriptBox["v", "\[RightVector]"], "||", 
          RowBox[{"+", 
           RowBox[{"||", 
            OverscriptBox["v", "\[RightVector]"], 
            SuperscriptBox["||", "2"]}]}]}]}]}]}]}], "\[IndentingNewLine]", 
     "               ", "=", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"||", 
        OverscriptBox["u", "\[RightVector]"], "||", 
        RowBox[{"+", 
         RowBox[{"||", 
          OverscriptBox["v", "\[RightVector]"], "||"}]}]}], ")"}], "2"]}]}]}],
   TraditionalForm]}],
 FormatType->
  "TraditionalForm",ExpressionUUID->"8bfea612-a143-48db-8ad9-ea9d9aeb84b0"]], \
"Text",
 CellChangeTimes->{{3.7140814962658443`*^9, 3.7140817724899187`*^9}},
 TextAlignment->Center,ExpressionUUID->"fbf4945a-a7f9-4b34-b7a1-dc256843bf07"],

Cell[TextData[{
 "Thus we have shown that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", 
    RowBox[{
     OverscriptBox["u", "\[RightVector]"], "+", 
     OverscriptBox["v", "\[RightVector]"]}], 
    SuperscriptBox["||", "2"], " ", 
    RowBox[{"\[LessEqual]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"||", 
        OverscriptBox["u", "\[RightVector]"], "||", 
        RowBox[{"+", 
         RowBox[{"||", 
          OverscriptBox["v", "\[RightVector]"], "||"}]}]}], ")"}], "2"]}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "6e3f49b0-4817-4dbb-a3ba-96c66e79a645"],
 ". Since both sides are positive numbers squared, we take the square root of \
both sides and the inequality is preserved, giving the desired inequality: ",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", 
    RowBox[{
     OverscriptBox["u", "\[RightVector]"], "+", 
     OverscriptBox["v", "\[RightVector]"]}], "||", 
    RowBox[{"\[LessEqual]", 
     RowBox[{"||", 
      OverscriptBox["u", "\[RightVector]"], "||", " ", 
      RowBox[{"+", " ", 
       RowBox[{"||", 
        OverscriptBox["v", "\[RightVector]"], "||"}]}]}]}]}], 
   TraditionalForm]],ExpressionUUID->"dc32ccea-5139-4c16-8370-51172eb860d7"],
 "."
}], "Text",
 CellChangeTimes->{{3.7140817866935167`*^9, 
  3.714081876746107*^9}},ExpressionUUID->"9a726ace-ded7-4d8c-8b16-\
c31fd406d956"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 11 (Little Challenge)", "Section",
 CellChangeTimes->{{3.713236043904008*^9, 3.713236045023195*^9}, {
   3.713835658285311*^9, 3.713835663773138*^9}, 
   3.7138726490089736`*^9},ExpressionUUID->"feb30fc7-7eb1-49f5-9026-\
f00ef675d0a8"],

Cell[TextData[{
 "Use vector projection to find the (shortest) distance from a point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", " ", "=", " ", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", 
      SubscriptBox["y", "1"]}], ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "26e0e263-309d-43fa-a1c1-f41ec46aedff"],
 " to the line ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"ax", "+", "by"}], "=", "c"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "031dae2c-737d-480d-94e7-f3c8ba19856c"],
 ". (",
 StyleBox["Hint:",
  FontSlant->"Italic"],
 " Think about what direction you would want to move in from ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "0ae6475f-6424-4d96-940e-48a04fbbf150"],
 " to get to the line as quickly as possible.)"
}], "Text",
 CellChangeTimes->{{3.7132370804592648`*^9, 3.713237151603834*^9}, {
   3.7132371849388576`*^9, 3.713237188708766*^9}, 3.713237221809761*^9, {
   3.713468989450657*^9, 3.713468996554131*^9}, {3.7136511180228157`*^9, 
   3.7136511403920093`*^9}, {3.713835677483931*^9, 3.7138357399262533`*^9}, {
   3.7138358169191837`*^9, 3.7138358213433695`*^9}, {3.7138358901459007`*^9, 
   3.7138359249292536`*^9}},ExpressionUUID->"664b5388-9817-4cb3-be39-\
505b6a391a10"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.71408249036341*^9, 
  3.7140824989093723`*^9}},ExpressionUUID->"261b75df-a6e6-4ae3-bf5d-\
427654969a20"],

Cell["\<\
The idea here is that the quickest way to move from the point to the line is \
to move perpendicular to the line. What we will do is find a vector \
perpendicular to the line which has one end on the line and the other end on \
the point.\
\>", "Text",
 CellChangeTimes->{{3.71408249036341*^9, 3.7140825936807117`*^9}, {
  3.7140829745283036`*^9, 
  3.71408298885718*^9}},ExpressionUUID->"d31b49f7-26f6-478d-9994-\
7a13fb2a234f"],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s begin by finding a vector that points in the same \
direction as the line by finding the displacement vector between two points \
on the line. Two points on the line are ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     FractionBox["c", "a"], ",", "0"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "47a936ee-70fd-4a3b-8d0a-c47c7827d580"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", 
     FractionBox["c", "b"]}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "6210f1e3-6ba2-41a5-bb8a-ef3a356d534a"],
 ". We create the displacement vector between them to get ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["v", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      FractionBox["c", "a"], ",", 
      RowBox[{"-", 
       FractionBox["c", "b"]}]}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "9647d08e-57bf-4f47-aece-dd65a8bea479"],
 ". This vector is a little messy, so let\[CloseCurlyQuote]s create a new \
vector which is parallel (so still in the same direction as the line): ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["w", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["ab", "c"]}], 
      OverscriptBox["v", "\[RightVector]"]}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"b", ",", 
       RowBox[{"-", "a"}]}], "\[RightAngleBracket]"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "3e274247-0ae4-4fcd-a363-c50fbde91013"],
 ". What we really want is a vector which is perpendicular to the line, so \
now that we have ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["w", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f9c48f57-283b-4ba1-86d5-5e536dfcec1a"],
 " we can see that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["n", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"a", ",", "b"}], "\[RightAngleBracket]"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "2a312def-7b15-46b7-a916-857a011b16c8"],
 " is perpendicular to ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["w", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d17296b5-4f03-40de-812a-954a7fffc76b"],
 ", and hence to the line. (Note that the points we chose on the line above \
require that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", ",", 
    RowBox[{"b", "\[NotEqual]", "0"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "b791c563-0e7b-4876-85b5-e2d49091f03f"],
 " to exist and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", "\[NotEqual]", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e0aaf7ac-63d7-436f-aabe-2f3e9cab2b08"],
 " in order to be different. However, if one of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d615cd69-da92-45ae-89ae-2a2c2423a5e6"],
 " or ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "1a51c2ae-b2a9-4f27-8e20-1a4bf6dd2a74"],
 " is ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "96ab8692-5760-481e-adcb-674383ddc8b1"],
 " (they cannot both be ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "372b12fa-b489-48f3-b0b7-64d0e9e8889c"],
 "), then it is easy to tell that ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["i", "^"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f29d7993-8b0a-43ba-9f3d-d8bed84e9e9f"],
 " or ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["j", "^"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "af87f8a3-746c-4888-91ff-494b46f651d9"],
 " will be perpendicular to the line; if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", "=", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "491e263a-6b66-4798-a07a-6981eb7c2ef6"],
 ", then use ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "0"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4ac45101-160f-452f-88a6-660e04e38fd0"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"b", ",", 
     RowBox[{"-", "a"}]}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "774d11a0-ab56-49af-a1d3-f932604804e6"],
 " as your two points.)"
}], "Text",
 CellChangeTimes->{{3.71408249036341*^9, 3.7140825936807117`*^9}, {
  3.7140829745283036`*^9, 3.7140830124457917`*^9}, {3.7140831882165794`*^9, 
  3.714083305088683*^9}, {3.714083355169111*^9, 3.714083356705635*^9}, {
  3.714083399051262*^9, 
  3.7140837415476837`*^9}},ExpressionUUID->"803c4102-5773-4c41-9fc1-\
45329f867aa1"],

Cell[TextData[{
 "Now that we have our perpendicular vector to the line, we just need to \
connect the line to the point with any ol\[CloseCurlyQuote] vector. Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", "=", 
    RowBox[{"(", 
     RowBox[{"x", ",", "y"}], ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "437ebff1-db63-47e6-b77b-29544a8f3b5d"],
 " represent some point on the line (we don\[CloseCurlyQuote]t need to pick \
any point in particular) and create the displacement vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["PQ", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"x", "-", 
       SubscriptBox["x", "1"]}], ",", 
      RowBox[{"y", "-", 
       SubscriptBox["y", "1"]}]}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "6ab0a690-4d6c-4df2-b850-aa56de0a4bc2"],
 ". Then, if we project ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["PQ", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "a1fe674a-ecd2-4ee9-b760-8008fa81a19b"],
 " onto ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["n", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "8e3a594e-0df5-4942-bce0-8e0c09539224"],
 ", we get a vector which is perpendicular to the line and starts on the line \
and ends on the point, thus we want the magnitude of this vector."
}], "Text",
 CellChangeTimes->{{3.71408249036341*^9, 3.7140825936807117`*^9}, {
  3.7140829745283036`*^9, 3.7140830124457917`*^9}, {3.7140831882165794`*^9, 
  3.714083305088683*^9}, {3.714083355169111*^9, 3.714083356705635*^9}, {
  3.714083399051262*^9, 3.714083770600021*^9}, {3.7140838229782305`*^9, 
  3.7140839823760962`*^9}},ExpressionUUID->"69d6eddb-7ef5-4e48-86a6-\
3e829afbdbe1"],

Cell[TextData[Cell[BoxData[{
 FormBox[
  StyleBox[
   RowBox[{"D", "=", 
    RowBox[{
     RowBox[{"||", 
      RowBox[{
       SubscriptBox["proj", 
        OverscriptBox["n", "\[RightVector]"]], 
       OverscriptBox["PQ", "\[RightVector]"]}], "||"}], "=", 
     RowBox[{
      RowBox[{"|", 
       RowBox[{
        SubscriptBox["comp", 
         OverscriptBox["n", "\[RightVector]"]], 
        OverscriptBox["PQ", "\[RightVector]"]}], "|"}], "=", 
      RowBox[{
       RowBox[{"|", 
        FractionBox[
         RowBox[{
          OverscriptBox["PQ", "\[RightVector]"], "\[CenterDot]", 
          OverscriptBox["n", "\[RightVector]"]}], 
         RowBox[{"||", 
          OverscriptBox["n", "\[RightVector]"], "||"}]], "|"}], "=", 
       FractionBox[
        RowBox[{"|", 
         RowBox[{
          OverscriptBox["PQ", "\[RightVector]"], "\[CenterDot]", 
          OverscriptBox["n", "\[RightVector]"]}], "|"}], 
        RowBox[{"||", 
         OverscriptBox["n", "\[RightVector]"], "||"}]]}]}]}]}],
   FontSize->18], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  StyleBox[
   RowBox[{"    ", 
    RowBox[{"=", 
     RowBox[{
      FractionBox[
       RowBox[{"|", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", 
            SubscriptBox["x", "1"]}], ")"}], 
          RowBox[{"(", "a", ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y", "-", 
            SubscriptBox["y", "1"]}], ")"}], 
          RowBox[{"(", "b", ")"}]}]}], "|"}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox["b", "2"]}]]], "=", 
      FractionBox[
       RowBox[{"|", 
        RowBox[{"ax", "-", 
         SubscriptBox["ax", "1"], "+", "by", "-", 
         SubscriptBox["by", "1"]}], "|"}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox["b", "2"]}]]]}]}]}],
   FontSize->18], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  StyleBox[
   RowBox[{"    ", 
    RowBox[{"=", 
     RowBox[{
      FractionBox[
       RowBox[{"|", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"ax", "+", "by"}], ")"}], "-", 
         SubscriptBox["ax", "1"], "-", 
         SubscriptBox["by", "1"]}], "|"}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox["b", "2"]}]]], "=", 
      FractionBox[
       RowBox[{"|", 
        RowBox[{"c", "-", 
         SubscriptBox["ax", "1"], "-", 
         SubscriptBox["by", "1"]}], "|"}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox["b", "2"]}]]]}]}]}],
   FontSize->18], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  StyleBox[
   RowBox[{"    ", 
    RowBox[{"=", 
     FractionBox[
      RowBox[{"|", 
       RowBox[{
        SubscriptBox["ax", "1"], "+", 
        SubscriptBox["by", "1"], "-", "c"}], "|"}], 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}]]]}]}],
   FontSize->18], TraditionalForm]}],
 FormatType->
  "TraditionalForm",ExpressionUUID->"1eb70475-c36b-42c3-a0b4-44c3674be5f4"]], \
"Text",
 CellChangeTimes->{{3.71408249036341*^9, 3.7140825936807117`*^9}, {
  3.7140829745283036`*^9, 3.7140830124457917`*^9}, {3.7140831882165794`*^9, 
  3.714083305088683*^9}, {3.714083355169111*^9, 3.714083356705635*^9}, {
  3.714083399051262*^9, 3.714083770600021*^9}, {3.7140838229782305`*^9, 
  3.7140842328355975`*^9}, {3.714084796222765*^9, 3.714084825366744*^9}},
 TextAlignment->Center,ExpressionUUID->"724a871e-5315-4881-a62e-c4e186e253ea"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1280, 941},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
PrintingPageRange->{Automatic, Automatic},
FrontEndVersion->"11.1 for Microsoft Windows (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 231, 4, 101, "Title", "ExpressionUUID" -> \
"18cde08b-1b4c-4b17-937d-88c2537510d4"],
Cell[CellGroupData[{
Cell[836, 30, 476, 9, 115, "Chapter", "ExpressionUUID" -> \
"2686c348-2164-4008-a28b-7b9b2921fdc0"],
Cell[1315, 41, 383, 7, 30, "Text", "ExpressionUUID" -> \
"b556ef5f-feea-4b81-8431-bd0b77b28981"],
Cell[CellGroupData[{
Cell[1723, 52, 397, 10, 22, "Code", "ExpressionUUID" -> \
"ee24972e-5cdf-4b09-99c4-a324ddf3ac04",
 CellOpen->False],
Cell[2123, 64, 831, 22, 30, "Output", "ExpressionUUID" -> \
"85584dbe-537f-4a39-a10a-8888852cd259"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2991, 91, 207, 4, 70, "Section", "ExpressionUUID" -> \
"5c1cb392-1d29-496d-a754-8662627f59b2"],
Cell[3201, 97, 543, 10, 30, "Text", "ExpressionUUID" -> \
"905edc2e-ac20-4961-ab41-93b51208904f"],
Cell[CellGroupData[{
Cell[3769, 111, 886, 17, 41, "ItemNumbered", "ExpressionUUID" -> \
"1f3bc904-c3e6-42e4-bcf2-8723aead5e46"],
Cell[4658, 130, 902, 18, 41, "ItemNumbered", "ExpressionUUID" -> \
"0d68e1d2-4fc7-49de-a815-8e143d68dca8"],
Cell[5563, 150, 914, 18, 41, "ItemNumbered", "ExpressionUUID" -> \
"390bef1d-52a2-481d-b76a-fa4ca1fa7f3a"],
Cell[6480, 170, 904, 18, 41, "ItemNumbered", "ExpressionUUID" -> \
"886f7b7a-a7dd-488e-9cac-8fba856ead90"],
Cell[7387, 190, 878, 17, 35, "ItemNumbered", "ExpressionUUID" -> \
"38193cc4-c61f-4b00-863b-ae7d853d3df7"],
Cell[8268, 209, 903, 18, 41, "ItemNumbered", "ExpressionUUID" -> \
"acb33c85-505a-4cfd-aa17-210c071f5cae"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9208, 232, 156, 3, 49, "Subsection", "ExpressionUUID" -> \
"18c22fb9-2e70-4711-88dd-a08aafe973de"],
Cell[CellGroupData[{
Cell[9389, 239, 475, 13, 41, "ItemNumbered", "ExpressionUUID" -> \
"e107b0f5-8a8b-4c46-ba89-e59b68ca7701"],
Cell[9867, 254, 205, 3, 30, "ItemNumbered", "ExpressionUUID" -> \
"9bc2e609-40c5-4bf7-826e-aae12f4853b5"],
Cell[10075, 259, 207, 3, 30, "ItemNumbered", "ExpressionUUID" -> \
"2a06fff7-709f-4e9e-9da5-b4dc0e59ac1a"],
Cell[10285, 264, 221, 5, 30, "ItemNumbered", "ExpressionUUID" -> \
"8b4cb748-6861-46f0-8e55-466bfa2920df"],
Cell[10509, 271, 446, 12, 35, "ItemNumbered", "ExpressionUUID" -> \
"0e59d9a8-4e95-40ac-9176-8e01b07abd3d"],
Cell[10958, 285, 444, 12, 32, "ItemNumbered", "ExpressionUUID" -> \
"3e36e8e3-5b66-483d-8cc9-3f75d7d07ce3"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11463, 304, 158, 3, 70, "Section", "ExpressionUUID" -> \
"a950e41f-9296-419b-88ef-5d990129615c"],
Cell[11624, 309, 1043, 20, 33, "Text", "ExpressionUUID" -> \
"1d9ab7fd-e147-4aff-97f9-463aa05e410e"],
Cell[CellGroupData[{
Cell[12692, 333, 1417, 29, 32, "ItemNumbered", "ExpressionUUID" -> \
"13101070-973a-4d97-9a0c-f160a5956056"],
Cell[14112, 364, 1500, 31, 32, "ItemNumbered", "ExpressionUUID" -> \
"80d0f4eb-5f2d-43f9-9dce-b2aa8f56fe41"],
Cell[15615, 397, 1606, 38, 34, "ItemNumbered", "ExpressionUUID" -> \
"f3be4c00-b209-4d90-8c24-da4a5a238a35"],
Cell[17224, 437, 1966, 51, 45, "ItemNumbered", "ExpressionUUID" -> \
"0436f757-3d3e-4b86-bc2c-904ed574a7c8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19227, 493, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"5cbdedcc-48ae-4a97-9409-224e2b706a40"],
Cell[CellGroupData[{
Cell[19410, 500, 756, 23, 32, "ItemNumbered", "ExpressionUUID" -> \
"88f99702-eb56-42e7-9a87-2b8ac9cd6a8f"],
Cell[20169, 525, 865, 27, 32, "ItemNumbered", "ExpressionUUID" -> \
"bd33589e-3749-4705-99af-fa52041048e2"],
Cell[21037, 554, 820, 25, 32, "ItemNumbered", "ExpressionUUID" -> \
"3b8cd10b-5088-437b-b83e-46de3b864ce1"],
Cell[21860, 581, 928, 26, 42, "ItemNumbered", "ExpressionUUID" -> \
"51918772-dc1c-47b2-a6b9-244f679557fa"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22849, 614, 156, 3, 70, "Section", "ExpressionUUID" -> \
"3dbbfe32-3fd7-4d3d-9a43-cc518ad98f59"],
Cell[23008, 619, 1153, 19, 49, "Text", "ExpressionUUID" -> \
"0100d4d7-4127-4e00-ab65-7d02dfa5e232",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[24186, 642, 315, 8, 30, "Input", "ExpressionUUID" -> \
"8d398533-74e7-4378-ba40-c923d4249b9d"],
Cell[24504, 652, 197, 3, 30, "Output", "ExpressionUUID" -> \
"d6e2b4b1-db44-4839-83de-af95932ba4c8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24738, 660, 667, 17, 35, "ItemNumbered", "ExpressionUUID" -> \
"05379c63-a372-4387-9c68-e30c8622c44d"],
Cell[25408, 679, 710, 18, 35, "ItemNumbered", "ExpressionUUID" -> \
"fa519ece-4000-4a35-8ece-494e60107fab"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26155, 702, 156, 3, 49, "Subsection", "ExpressionUUID" -> \
"66399f8f-4215-4956-b457-ef1db88410bf"],
Cell[CellGroupData[{
Cell[26336, 709, 2151, 75, 51, "ItemNumbered", "ExpressionUUID" -> \
"b2dbcc23-2e8b-489b-ad81-354724c98a1e"],
Cell[28490, 786, 2442, 83, 74, "ItemNumbered", "ExpressionUUID" -> \
"57d84f58-1f73-4928-8f3b-b7824347d3b4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30969, 874, 334, 10, 39, "Input", "ExpressionUUID" -> \
"c54e45f2-f3d2-4b9e-aa07-c91a63cb3fdc"],
Cell[31306, 886, 171, 3, 30, "Output", "ExpressionUUID" -> \
"88cf8df5-b8bd-486e-9d5d-2e40d7ba7fc9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31514, 894, 410, 14, 53, "Input", "ExpressionUUID" -> \
"544c0377-7287-4350-a258-bfc4ef4e6226"],
Cell[31927, 910, 149, 3, 30, "Output", "ExpressionUUID" -> \
"4dc3b344-cd28-44a9-a239-86e1d3dd5ceb"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32137, 920, 156, 3, 70, "Section", "ExpressionUUID" -> \
"78fcd753-4dc2-4199-b8f2-c074b97772ee"],
Cell[32296, 925, 656, 11, 30, "Text", "ExpressionUUID" -> \
"7043e6f1-0450-4c2a-9ff8-fbe18cdbebc4"],
Cell[CellGroupData[{
Cell[32977, 940, 1203, 26, 35, "ItemNumbered", "ExpressionUUID" -> \
"c7203339-cf83-4e8a-9b45-0f642eee9dd3"],
Cell[34183, 968, 1204, 24, 35, "ItemNumbered", "ExpressionUUID" -> \
"7c0c68a2-dca7-4c8f-a084-1cd8b310d1d5"],
Cell[35390, 994, 1345, 33, 35, "ItemNumbered", "ExpressionUUID" -> \
"6e66a793-f63c-4b5a-971f-e4ebba2a7a5d"],
Cell[36738, 1029, 1389, 35, 35, "ItemNumbered", "ExpressionUUID" -> \
"e1e2f842-4c6f-4103-8b86-a27cc5637990"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38164, 1069, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"0bb6b29c-5460-48e8-991e-c1bf04fed493"],
Cell[CellGroupData[{
Cell[38347, 1076, 2587, 78, 95, "ItemNumbered", "ExpressionUUID" -> \
"0a205519-ae6f-417c-b0ac-c9464ffb438a"],
Cell[40937, 1156, 1101, 31, 36, "ItemNumbered", "ExpressionUUID" -> \
"2fab7bf7-16fd-436a-92a7-348f8061c56b"],
Cell[42041, 1189, 960, 31, 35, "ItemNumbered", "ExpressionUUID" -> \
"e99921d2-15c5-4152-8bd8-cb5d4f9a4ece"],
Cell[43004, 1222, 2014, 64, 61, "ItemNumbered", "ExpressionUUID" -> \
"fc27e87f-5ad9-4429-8aca-7f95b9105e30"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45079, 1293, 181, 3, 70, "Section", "ExpressionUUID" -> \
"00c4aa90-e57a-4732-ac49-15535b6b216a"],
Cell[45263, 1298, 775, 18, 37, "Text", "ExpressionUUID" -> \
"268d2e55-d59a-4360-b128-9f9ae3def703"],
Cell[CellGroupData[{
Cell[46063, 1320, 1030, 21, 35, "ItemNumbered", "ExpressionUUID" -> \
"dc0f9d36-a288-4274-9b06-fa1751f9a37c"],
Cell[47096, 1343, 1018, 21, 35, "ItemNumbered", "ExpressionUUID" -> \
"ee6dd128-ba2a-4b50-8ea5-cb561817a923"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48151, 1369, 159, 3, 49, "Subsection", "ExpressionUUID" -> \
"ac697b12-ef81-4e56-8419-2fe88dddd758"],
Cell[CellGroupData[{
Cell[48335, 1376, 1517, 44, 49, "ItemNumbered", "ExpressionUUID" -> \
"77cd958c-67fd-4748-ac86-873d75e8cd24"],
Cell[49855, 1422, 1765, 51, 50, "ItemNumbered", "ExpressionUUID" -> \
"8441abc0-2507-4ca5-8343-7052332f4f8c"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51681, 1480, 153, 3, 70, "Section", "ExpressionUUID" -> \
"cfdff48e-01e0-4898-badc-3c3aca29ea42"],
Cell[51837, 1485, 994, 25, 49, "Text", "ExpressionUUID" -> \
"556ce47e-c53f-4489-9a65-1a2343ddad8e"],
Cell[CellGroupData[{
Cell[52856, 1514, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"0c99a398-207b-474f-9b34-a94c49191a5b"],
Cell[53017, 1519, 284, 7, 30, "Text", "ExpressionUUID" -> \
"3dc9f0f9-ac9e-46b2-ad5e-b20bb6d20260"],
Cell[53304, 1528, 1022, 28, 53, "Text", "ExpressionUUID" -> \
"6d40ffe8-be57-40da-8f20-dc3ba187d32a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[54375, 1562, 156, 3, 70, "Section", "ExpressionUUID" -> \
"20b4726b-6108-4617-b69e-b88b08022cf3"],
Cell[54534, 1567, 2618, 70, 81, "Text", "ExpressionUUID" -> \
"f288b847-8841-4649-8c09-b5427e4fc67d"],
Cell[CellGroupData[{
Cell[57177, 1641, 7503, 222, 19, "Input", "ExpressionUUID" -> \
"6dd4e1b6-179d-4d37-b2dc-aa7f3bac75e4",
 CellOpen->False],
Cell[64683, 1865, 2294, 52, 416, "Output", "ExpressionUUID" -> \
"1f291b1d-90c3-4406-81dc-ff718185016c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67014, 1922, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"c54946ca-f43b-4422-878e-238e555d2002"],
Cell[67175, 1927, 353, 7, 30, "Text", "ExpressionUUID" -> \
"2510a53a-7b56-4b53-96aa-92835b427e01"],
Cell[67531, 1936, 1948, 56, 78, "Text", "ExpressionUUID" -> \
"a72700f8-8363-4be0-b379-efcd1f532234"],
Cell[69482, 1994, 3006, 104, 220, "Text", "ExpressionUUID" -> \
"236ab699-65a4-49d0-9cac-9ac2bc847cc0"],
Cell[CellGroupData[{
Cell[72513, 2102, 340, 10, 30, "Input", "ExpressionUUID" -> \
"132120e3-fa36-4f1b-a2d8-edfc16c6e16c"],
Cell[72856, 2114, 150, 3, 30, "Output", "ExpressionUUID" -> \
"51056486-5a88-4cb7-af63-9b42e202768c"]
}, Open  ]],
Cell[73021, 2120, 377, 11, 30, "Text", "ExpressionUUID" -> \
"8e734cb5-01d5-41f7-bcb7-39c0a72fefc9"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[73447, 2137, 173, 2, 70, "Section", "ExpressionUUID" -> \
"cf29a0ce-5007-4b71-bb63-1b977e8b9418"],
Cell[73623, 2141, 2064, 61, 37, "Text", "ExpressionUUID" -> \
"38d79a8b-e7bf-4b29-979b-d991b5a53423"],
Cell[CellGroupData[{
Cell[75712, 2206, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"467fdfa8-5d3a-4d33-833e-a9b47cb3e541"],
Cell[75873, 2211, 184, 3, 30, "Text", "ExpressionUUID" -> \
"a5522b5e-a538-4b2c-9486-4be11c34f03c"],
Cell[76060, 2216, 2425, 64, 108, "Text", "ExpressionUUID" -> \
"5e22cc83-6d9c-44de-8c89-0d706238e420"],
Cell[78488, 2282, 223, 4, 30, "Text", "ExpressionUUID" -> \
"f2b69d90-766c-46f4-a72d-2a2e9bcabf4e"],
Cell[CellGroupData[{
Cell[78736, 2290, 3809, 110, 155, "Input", "ExpressionUUID" -> \
"5abd2656-3fb6-4cd8-b9af-4d0a69bab197"],
Cell[82548, 2402, 1857, 38, 447, "Output", "ExpressionUUID" -> \
"1a6d80ae-4fa7-4417-8e9d-2351759bf0ad"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[84466, 2447, 379, 6, 70, "Section", "ExpressionUUID" -> \
"ff456d06-769e-4034-bf66-53c4343af8ab"],
Cell[84848, 2455, 944, 24, 33, "Text", "ExpressionUUID" -> \
"efaca90e-287b-44f2-b86d-94724c06d1dc"],
Cell[85795, 2481, 828, 17, 36, "Text", "ExpressionUUID" -> \
"36ec7416-54f4-48f6-ad36-e914763425aa"],
Cell[CellGroupData[{
Cell[86648, 2502, 156, 3, 49, "Subsection", "ExpressionUUID" -> \
"813e0d9e-72d5-4cfb-a2fc-7d265c87e951"],
Cell[86807, 2507, 144, 3, 30, "Text", "ExpressionUUID" -> \
"7d141712-8072-447c-b876-4e55eda69c7d"],
Cell[86954, 2512, 1224, 31, 36, "Text", "ExpressionUUID" -> \
"055a6abe-2e78-42c1-9b88-3ed72280d373"],
Cell[88181, 2545, 406, 13, 33, "Text", "ExpressionUUID" -> \
"eb5dba3a-49de-4fce-a76e-6c0a91458638"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[88636, 2564, 357, 5, 70, "Section", "ExpressionUUID" -> \
"dfd708c9-4d42-4b8f-b4ab-61511744fb75"],
Cell[88996, 2571, 441, 11, 30, "Text", "ExpressionUUID" -> \
"ecdbc96c-ff26-48c0-80e3-e6fd55ca9497"],
Cell[89440, 2584, 812, 18, 33, "Text", "ExpressionUUID" -> \
"15b1e942-30c7-413c-af56-225871f31ef6"],
Cell[90255, 2604, 1051, 27, 36, "Text", "ExpressionUUID" -> \
"2f4261bd-3bbd-41b3-ad61-46aa670c125b"],
Cell[CellGroupData[{
Cell[91331, 2635, 157, 3, 49, "Subsection", "ExpressionUUID" -> \
"c506ca52-b30e-498b-ac44-5bc3ec2966b8"],
Cell[91491, 2640, 3248, 87, 156, "Text", "ExpressionUUID" -> \
"fbf4945a-a7f9-4b34-b7a1-dc256843bf07"],
Cell[94742, 2729, 1375, 39, 59, "Text", "ExpressionUUID" -> \
"9a726ace-ded7-4d8c-8b16-c31fd406d956"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[96166, 2774, 249, 4, 70, "Section", "ExpressionUUID" -> \
"e67bc4f8-5389-44a8-a6ff-a595a15af149"],
Cell[96418, 2780, 1350, 34, 49, "Text", "ExpressionUUID" -> \
"368fe05f-8ff6-4bf5-a80d-c19ce5cc30b2"],
Cell[CellGroupData[{
Cell[97793, 2818, 157, 3, 49, "Subsection", "ExpressionUUID" -> \
"261b75df-a6e6-4ae3-bf5d-427654969a20"],
Cell[97953, 2823, 439, 9, 49, "Text", "ExpressionUUID" -> \
"d31b49f7-26f6-478d-9994-7a13fb2a234f"],
Cell[98395, 2834, 4998, 144, 148, "Text", "ExpressionUUID" -> \
"803c4102-5773-4c41-9fc1-45329f867aa1"],
Cell[103396, 2980, 1856, 45, 73, "Text", "ExpressionUUID" -> \
"69d6eddb-7ef5-4e48-86a6-3e829afbdbe1"],
Cell[105255, 3027, 3625, 112, 222, "Text", "ExpressionUUID" -> \
"724a871e-5315-4881-a62e-c4e186e253ea"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

